/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.rbac.ConfigurableRoleMapper;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.dmr.ModelNode;

public class PrincipalRemove
implements OperationStepHandler {
    private final ConfigurableRoleMapper roleMapper;
    private final ConfigurableRoleMapper.MatchType matchType;

    private PrincipalRemove(ConfigurableRoleMapper roleMapper, ConfigurableRoleMapper.MatchType matchType) {
        this.roleMapper = roleMapper;
        this.matchType = matchType;
    }

    public static OperationStepHandler createForInclude(ConfigurableRoleMapper roleMapper) {
        return new PrincipalRemove(roleMapper, ConfigurableRoleMapper.MatchType.INCLUDE);
    }

    public static OperationStepHandler createForExclude(ConfigurableRoleMapper roleMapper) {
        return new PrincipalRemove(roleMapper, ConfigurableRoleMapper.MatchType.EXCLUDE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        ConfigurableRoleMapper.PrincipalType principalType = PrincipalResourceDefinition.getPrincipalType(context, model);
        String realm = PrincipalResourceDefinition.getRealm(context, model);
        String name = PrincipalResourceDefinition.getName(context, model);
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (this.matchType == ConfigurableRoleMapper.MatchType.INCLUDE) {
            RbacSanityCheckOperation.registerOperation(context);
        }
        this.registerRuntimeRemove(context, roleName, principalType, name, realm);
        context.stepCompleted();
    }

    private void registerRuntimeRemove(OperationContext context, final String roleName, final ConfigurableRoleMapper.PrincipalType principalType, final String name, final String realm) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (!PrincipalRemove.this.roleMapper.removePrincipal(roleName, principalType, PrincipalRemove.this.matchType, name, realm)) {
                    context.restartRequired();
                    throw DomainManagementMessages.MESSAGES.inconsistentRbacRuntimeState();
                }
                PrincipalRemove.this.registerRollbackHandler(context, roleName, principalType, name, realm);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final String roleName, final ConfigurableRoleMapper.PrincipalType principalType, final String name, final String realm) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!PrincipalRemove.this.roleMapper.addPrincipal(roleName, principalType, PrincipalRemove.this.matchType, name, realm, false)) {
                    context.restartRequired();
                }
            }
        });
    }
}

