/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.rbac.ConfigurableRoleMapper;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.IsCallerInRoleOperation;
import org.jboss.as.domain.management.access.PrincipalResourceDefinition;
import org.jboss.as.domain.management.access.RoleMappingAdd;
import org.jboss.as.domain.management.access.RoleMappingRemove;
import org.jboss.dmr.ModelNode;

public class RoleMappingResourceDefinition
extends SimpleResourceDefinition {
    private final ConfigurableRoleMapper roleMapper;

    private RoleMappingResourceDefinition(ConfigurableRoleMapper roleMapper) {
        super(PathElement.pathElement((String)"role-mapping"), DomainManagementResolver.getResolver("core.access-control.role-mapping"), RoleMappingAdd.create(roleMapper), RoleMappingRemove.create(roleMapper));
        this.roleMapper = roleMapper;
    }

    public static SimpleResourceDefinition create(ConfigurableRoleMapper roleMapper) {
        return new RoleMappingResourceDefinition(roleMapper);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)PrincipalResourceDefinition.includeResourceDefinition(this.roleMapper));
        resourceRegistration.registerSubModel((ResourceDefinition)PrincipalResourceDefinition.excludeResourceDefinition(this.roleMapper));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)IsCallerInRoleOperation.DEFINITION, IsCallerInRoleOperation.create((RoleMapper)this.roleMapper));
    }

    static String getRoleName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        for (PathElement current : address) {
            if (!"role-mapping".equals(current.getKey())) continue;
            return current.getValue().toUpperCase();
        }
        throw new IllegalStateException();
    }
}

