/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.AbstractSensitivity;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;

public class SensitivityClassificationTypeResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"type");

    SensitivityClassificationTypeResourceDefinition() {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.sensitivity-classification-type"));
    }

    static Resource.ResourceEntry createResource(Map<String, SensitivityClassification> classificationsByType, String type, String name) {
        return SensitivityClassificationTypeResourceDefinition.createResource(classificationsByType, PathElement.pathElement((String)type, (String)name));
    }

    static Resource.ResourceEntry createResource(Map<String, SensitivityClassification> classificationsByType, PathElement pathElement) {
        return new SensitivityClassificationResource(pathElement, classificationsByType);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)SensitivityResourceDefinition.createSensitivityClassification());
    }

    private static class SensitivityClassificationResource
    extends AbstractClassificationResource {
        private static final Set<String> CHILD_TYPES = Collections.singleton("classification");
        private final Map<String, SensitivityClassification> classificationsByName;

        SensitivityClassificationResource(PathElement pathElement, Map<String, SensitivityClassification> classificationsByType) {
            super(pathElement);
            this.classificationsByName = classificationsByType;
        }

        public Set<String> getChildTypes() {
            return CHILD_TYPES;
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            SensitivityClassification classification;
            if (type.equals("classification") && (classification = this.classificationsByName.get(name)) != null) {
                return SensitivityResourceDefinition.createResource((AbstractSensitivity)classification, type, name);
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if (type.equals("classification")) {
                return this.classificationsByName.keySet();
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if (childType.equals("classification")) {
                HashSet<Resource.ResourceEntry> entries = new HashSet<Resource.ResourceEntry>();
                for (Map.Entry<String, SensitivityClassification> entry : this.classificationsByName.entrySet()) {
                    entries.add(SensitivityResourceDefinition.createResource((AbstractSensitivity)entry.getValue(), childType, entry.getKey()));
                }
                return entries;
            }
            return Collections.emptySet();
        }
    }
}

