/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.ConfigurableAuthorizer;
import org.jboss.as.controller.access.constraint.ServerGroupEffectConstraint;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleAdd;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.dmr.ModelNode;

class ServerGroupScopedRoleRemove
implements OperationStepHandler {
    private final Map<String, ServerGroupEffectConstraint> constraintMap;
    private final ConfigurableAuthorizer authorizer;

    ServerGroupScopedRoleRemove(Map<String, ServerGroupEffectConstraint> constraintMap, ConfigurableAuthorizer authorizer) {
        this.constraintMap = constraintMap;
        this.authorizer = authorizer;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final String roleName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                final String baseRole = ServerGroupScopedRoleResourceDefinition.BASE_ROLE.resolveModelAttribute(context, model).asString();
                final List serverGroupNodes = ServerGroupScopedRoleResourceDefinition.SERVER_GROUPS.resolveModelAttribute(context, model).asList();
                ServerGroupScopedRoleRemove.this.authorizer.removeScopedRole(roleName);
                ServerGroupScopedRoleRemove.this.constraintMap.remove(roleName);
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        ServerGroupScopedRoleAdd.addScopedRole(roleName, baseRole, serverGroupNodes, ServerGroupScopedRoleRemove.this.authorizer, ServerGroupScopedRoleRemove.this.constraintMap);
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

