/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.web.Attribute;
import org.jboss.as.web.Element;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebContainerDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebJSPDefinition;
import org.jboss.as.web.WebReWriteConditionDefinition;
import org.jboss.as.web.WebReWriteDefinition;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebValveDefinition;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class WebSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final WebSubsystemParser INSTANCE = new WebSubsystemParser();
    private static final String RULE_PREFIX = "rule-";
    private static final String CONDITION_PREFIX = "condition-";

    WebSubsystemParser() {
    }

    static WebSubsystemParser getInstance() {
        return INSTANCE;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode config;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        WebDefinition.DEFAULT_VIRTUAL_SERVER.marshallAsAttribute(node, true, (XMLStreamWriter)writer);
        WebDefinition.INSTANCE_ID.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        WebDefinition.NATIVE.marshallAsAttribute(node, true, (XMLStreamWriter)writer);
        if (node.hasDefined("configuration")) {
            this.writeContainerConfig(writer, node.get("configuration"));
        }
        if (node.hasDefined("connector")) {
            for (Property connector : node.get("connector").asPropertyList()) {
                config = connector.getValue();
                writer.writeStartElement(Element.CONNECTOR.getLocalName());
                writer.writeAttribute("name", connector.getName());
                for (AttributeDefinition attr : WebConnectorDefinition.CONNECTOR_ATTRIBUTES) {
                    if (!(attr instanceof SimpleAttributeDefinition)) continue;
                    ((SimpleAttributeDefinition)attr).marshallAsAttribute(config, true, (XMLStreamWriter)writer);
                }
                if (config.get(new String[]{WebExtension.SSL_PATH.getKey(), WebExtension.SSL_PATH.getValue()}).isDefined()) {
                    ModelNode sslConfig = config.get(new String[]{WebExtension.SSL_PATH.getKey(), WebExtension.SSL_PATH.getValue()});
                    writer.writeStartElement(Element.SSL.getLocalName());
                    WebSSLDefinition.NAME.marshallAsAttribute(sslConfig, (XMLStreamWriter)writer);
                    for (SimpleAttributeDefinition attr : WebSSLDefinition.SSL_ATTRIBUTES) {
                        attr.marshallAsAttribute(sslConfig, false, (XMLStreamWriter)writer);
                    }
                    writer.writeEndElement();
                }
                if (config.hasDefined("virtual-server")) {
                    for (ModelNode virtualServer : config.get("virtual-server").asList()) {
                        writer.writeEmptyElement("virtual-server");
                        writer.writeAttribute("name", virtualServer.asString());
                    }
                }
                writer.writeEndElement();
            }
        }
        if (node.hasDefined("virtual-server")) {
            for (Property host : node.get("virtual-server").asPropertyList()) {
                config = host.getValue();
                writer.writeStartElement(Element.VIRTUAL_SERVER.getLocalName());
                writer.writeAttribute("name", host.getName());
                WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.marshallAsAttribute(config, true, (XMLStreamWriter)writer);
                WebVirtualHostDefinition.DEFAULT_WEB_MODULE.marshallAsAttribute(config, true, (XMLStreamWriter)writer);
                if (config.hasDefined("alias")) {
                    for (ModelNode alias : config.get("alias").asList()) {
                        writer.writeEmptyElement("alias");
                        writer.writeAttribute("name", alias.asString());
                    }
                }
                if (config.get(new String[]{WebExtension.ACCESS_LOG_PATH.getKey(), WebExtension.ACCESS_LOG_PATH.getValue()}).isDefined()) {
                    ModelNode accessLog = config.get(new String[]{WebExtension.ACCESS_LOG_PATH.getKey(), WebExtension.ACCESS_LOG_PATH.getValue()});
                    writer.writeStartElement(Element.ACCESS_LOG.getLocalName());
                    for (SimpleAttributeDefinition attr : WebAccessLogDefinition.ACCESS_LOG_ATTRIBUTES) {
                        attr.marshallAsAttribute(accessLog, false, (XMLStreamWriter)writer);
                    }
                    if (accessLog.get(new String[]{WebExtension.DIRECTORY_PATH.getKey(), WebExtension.DIRECTORY_PATH.getValue()}).isDefined()) {
                        ModelNode directory = accessLog.get(new String[]{WebExtension.DIRECTORY_PATH.getKey(), WebExtension.DIRECTORY_PATH.getValue()});
                        String name = Element.DIRECTORY.getLocalName();
                        boolean startwritten = false;
                        startwritten = this.writeAttribute(writer, WebAccessLogDirectoryDefinition.PATH, directory, startwritten, name);
                        if (startwritten = this.writeAttribute(writer, WebAccessLogDirectoryDefinition.RELATIVE_TO, directory, startwritten, name)) {
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                }
                if (config.hasDefined("rewrite")) {
                    for (ModelNode rewritenode : config.get("rewrite").asList()) {
                        Property prop = rewritenode.asProperty();
                        ModelNode rewrite = prop.getValue();
                        writer.writeStartElement("rewrite");
                        writer.writeAttribute("name", prop.getName());
                        WebReWriteDefinition.PATTERN.marshallAsAttribute(rewrite, false, (XMLStreamWriter)writer);
                        WebReWriteDefinition.SUBSTITUTION.marshallAsAttribute(rewrite, false, (XMLStreamWriter)writer);
                        WebReWriteDefinition.FLAGS.marshallAsAttribute(rewrite, false, (XMLStreamWriter)writer);
                        if (rewrite.hasDefined("condition")) {
                            for (ModelNode conditionnode : rewrite.get("condition").asList()) {
                                Property conditionProp = conditionnode.asProperty();
                                ModelNode condition = conditionProp.getValue();
                                writer.writeStartElement("condition");
                                writer.writeAttribute("name", conditionProp.getName());
                                WebReWriteConditionDefinition.TEST.marshallAsAttribute(condition, false, (XMLStreamWriter)writer);
                                WebReWriteConditionDefinition.PATTERN.marshallAsAttribute(condition, false, (XMLStreamWriter)writer);
                                WebReWriteConditionDefinition.FLAGS.marshallAsAttribute(condition, false, (XMLStreamWriter)writer);
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                    }
                }
                if (config.get(new String[]{WebExtension.SSO_PATH.getKey(), WebExtension.SSO_PATH.getValue()}).isDefined()) {
                    ModelNode sso = config.get(new String[]{WebExtension.SSO_PATH.getKey(), WebExtension.SSO_PATH.getValue()});
                    writer.writeStartElement("sso");
                    for (SimpleAttributeDefinition attr : WebSSODefinition.SSO_ATTRIBUTES) {
                        attr.marshallAsAttribute(sso, false, (XMLStreamWriter)writer);
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (node.hasDefined("valve")) {
                for (Property valve : node.get("valve").asPropertyList()) {
                    config = valve.getValue();
                    writer.writeStartElement(Element.VALVE.getLocalName());
                    writer.writeAttribute("name", valve.getName());
                    for (AttributeDefinition attr : WebValveDefinition.ATTRIBUTES) {
                        if (!(attr instanceof SimpleAttributeDefinition)) continue;
                        ((SimpleAttributeDefinition)attr).marshallAsAttribute(config, false, (XMLStreamWriter)writer);
                    }
                    if (config.hasDefined("param")) {
                        for (Property entry : config.get("param").asPropertyList()) {
                            writer.writeEmptyElement(Element.PARAM.getLocalName());
                            writer.writeAttribute(Attribute.PARAM_NAME.getLocalName(), entry.getName());
                            writer.writeAttribute(Attribute.PARAM_VALUE.getLocalName(), entry.getValue().asString());
                        }
                    }
                    writer.writeEndElement();
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeContainerConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        boolean containerConfigStartWritten = false;
        if (config.hasDefined("static-resources")) {
            containerConfigStartWritten = this.writeStaticResources(writer, config.get("static-resources"));
        }
        if (config.hasDefined("jsp-configuration")) {
            containerConfigStartWritten = this.writeJSPConfiguration(writer, config.get("jsp-configuration"), containerConfigStartWritten) || containerConfigStartWritten;
        }
        ModelNode container = config;
        if (config.hasDefined("container")) {
            container = config.get("container");
        }
        if (container.hasDefined("mime-mapping")) {
            if (!containerConfigStartWritten) {
                writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                containerConfigStartWritten = true;
            }
            WebContainerDefinition.MIME_MAPPINGS.marshallAsElement(container, (XMLStreamWriter)writer);
        }
        if (container.hasDefined("welcome-file")) {
            if (!containerConfigStartWritten) {
                writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                containerConfigStartWritten = true;
            }
            for (ModelNode file : container.get("welcome-file").asList()) {
                writer.writeStartElement(Element.WELCOME_FILE.getLocalName());
                writer.writeCharacters(file.asString());
                writer.writeEndElement();
            }
        }
        if (containerConfigStartWritten) {
            writer.writeEndElement();
        }
    }

    private boolean writeStaticResources(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        boolean startWritten = false;
        for (SimpleAttributeDefinition def : WebStaticResources.STATIC_ATTRIBUTES) {
            startWritten = this.writeStaticResourceAttribute(writer, def, config, startWritten) || startWritten;
        }
        if (startWritten) {
            writer.writeEndElement();
        }
        return startWritten;
    }

    private boolean writeStaticResourceAttribute(XMLExtendedStreamWriter writer, SimpleAttributeDefinition attribute, ModelNode config, boolean startWritten) throws XMLStreamException {
        if (attribute.isMarshallable(config, false)) {
            if (!startWritten) {
                writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                writer.writeStartElement(Element.STATIC_RESOURCES.getLocalName());
            }
            attribute.marshallAsAttribute(config, false, (XMLStreamWriter)writer);
            return true;
        }
        return false;
    }

    private boolean writeJSPConfiguration(XMLExtendedStreamWriter writer, ModelNode jsp, boolean containerConfigStartWritten) throws XMLStreamException {
        boolean startWritten = false;
        for (SimpleAttributeDefinition def : WebJSPDefinition.JSP_ATTRIBUTES) {
            startWritten = this.writeJspConfigAttribute(writer, def, jsp, startWritten, containerConfigStartWritten) || startWritten;
        }
        if (startWritten) {
            writer.writeEndElement();
        }
        return startWritten;
    }

    private boolean writeJspConfigAttribute(XMLExtendedStreamWriter writer, SimpleAttributeDefinition attribute, ModelNode config, boolean startWritten, boolean containerConfigStartWritten) throws XMLStreamException {
        if (attribute.isMarshallable(config, false)) {
            if (!startWritten) {
                if (!containerConfigStartWritten) {
                    writer.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
                }
                writer.writeStartElement(Element.JSP_CONFIGURATION.getLocalName());
            }
            attribute.marshallAsAttribute(config, false, (XMLStreamWriter)writer);
            return true;
        }
        return false;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"web")});
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address.toModelNode());
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NATIVE: {
                    WebDefinition.NATIVE.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block20;
                }
                case DEFAULT_VIRTUAL_SERVER: {
                    WebDefinition.DEFAULT_VIRTUAL_SERVER.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block20;
                }
                case INSTANCE_ID: {
                    WebDefinition.INSTANCE_ID.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(subsystem);
        boolean containerConfigDefined = false;
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (namespace) {
                case WEB_1_0: 
                case WEB_1_1: 
                case WEB_1_2: 
                case WEB_1_3: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONTAINER_CONFIG: {
                            WebSubsystemParser.parseContainerConfig(reader, address, list);
                            containerConfigDefined = true;
                            continue block21;
                        }
                        case CONNECTOR: {
                            WebSubsystemParser.parseConnector(reader, address, list);
                            continue block21;
                        }
                        case VIRTUAL_SERVER: {
                            WebSubsystemParser.parseHost(reader, address, list);
                            continue block21;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case WEB_1_4: 
                case WEB_2_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONTAINER_CONFIG: {
                            WebSubsystemParser.parseContainerConfig(reader, address, list);
                            containerConfigDefined = true;
                            continue block21;
                        }
                        case CONNECTOR: {
                            WebSubsystemParser.parseConnector(reader, address, list);
                            continue block21;
                        }
                        case VIRTUAL_SERVER: {
                            WebSubsystemParser.parseHost(reader, address, list);
                            continue block21;
                        }
                        case VALVE: {
                            WebSubsystemParser.parseValve(reader, address, list);
                            continue block21;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!containerConfigDefined) {
            WebSubsystemParser.addDefaultContainerConfig(address, list);
        }
    }

    private static void parseValve(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        ModelNode valve = new ModelNode();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                case MODULE: {
                    WebValveDefinition.MODULE.parseAndSetParameter(value, valve, (XMLStreamReader)reader);
                    continue block9;
                }
                case CLASS_NAME: {
                    WebValveDefinition.CLASS_NAME.parseAndSetParameter(value, valve, (XMLStreamReader)reader);
                    continue block9;
                }
                case ENABLED: {
                    WebValveDefinition.ENABLED.parseAndSetParameter(value, valve, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        valve.get("operation").set("add");
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{PathElement.pathElement((String)"valve", name)});
        valve.get("address").set(address.toModelNode());
        list.add(valve);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PARAM: {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.PARAM_NAME.getLocalName(), Attribute.PARAM_VALUE.getLocalName()});
                    valve.get("param").get(array[0]).set(array[1]);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseDirOrFile(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, PathElement filePath) throws XMLStreamException {
        PathAddress dirAddress = PathAddress.pathAddress((PathAddress)address, (PathElement[])new PathElement[]{filePath});
        ModelNode directory = new ModelNode();
        directory.get("operation").set("add");
        directory.get("address").set(dirAddress.toModelNode());
        int count2 = reader.getAttributeCount();
        block4: for (int i = 0; i < count2; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    directory.get("path").set(value);
                    continue block4;
                }
                case RELATIVE_TO: {
                    directory.get("relative-to").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        list.add(directory);
    }

    static void addDefaultContainerConfig(PathAddress parent, List<ModelNode> list) {
        ModelNode config = new ModelNode();
        PathAddress containerPath = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.CONTAINER_PATH});
        config.get("operation").set("add");
        config.get("address").set(containerPath.toModelNode());
        list.add(config);
        WebSubsystemParser.addDefaultStaticConfiguration(parent, list);
        WebSubsystemParser.addDefaultJSPConfiguration(parent, list);
    }

    private static void addDefaultJSPConfiguration(PathAddress parent, List<ModelNode> list) {
        PathAddress jspAddress = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.JSP_CONFIGURATION_PATH});
        ModelNode jsp = new ModelNode();
        jsp.get("operation").set("add");
        jsp.get("address").set(jspAddress.toModelNode());
        list.add(jsp);
    }

    private static void addDefaultStaticConfiguration(PathAddress parent, List<ModelNode> list) {
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.STATIC_RESOURCES_PATH});
        ModelNode resources = new ModelNode();
        resources.get("operation").set("add");
        resources.get("address").set(address.toModelNode());
        list.add(resources);
    }

    static void parseContainerConfig(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.CONTAINER_PATH});
        ModelNode config = new ModelNode();
        config.get("operation").set("add");
        config.get("address").set(address.toModelNode());
        list.add(config);
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        boolean staticResourcesConfigured = false;
        boolean jspConfigured = false;
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATIC_RESOURCES: {
                    WebSubsystemParser.parseStaticResources(reader, parent, list);
                    staticResourcesConfigured = true;
                    continue block6;
                }
                case JSP_CONFIGURATION: {
                    WebSubsystemParser.parseJSPConfiguration(reader, parent, list);
                    jspConfigured = true;
                    continue block6;
                }
                case MIME_MAPPING: {
                    String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                    WebContainerDefinition.MIME_MAPPINGS.parseAndAddParameterElement(array[0], array[1], config, reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block6;
                }
                case WELCOME_FILE: {
                    String welcomeFile = reader.getElementText().trim();
                    WebContainerDefinition.WELCOME_FILES.parseAndAddParameterElement(welcomeFile, config, (XMLStreamReader)reader);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!staticResourcesConfigured) {
            WebSubsystemParser.addDefaultStaticConfiguration(parent, list);
        }
        if (!jspConfigured) {
            WebSubsystemParser.addDefaultJSPConfiguration(parent, list);
        }
    }

    static void parseJSPConfiguration(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.JSP_CONFIGURATION_PATH});
        ModelNode jsp = new ModelNode();
        jsp.get("operation").set("add");
        jsp.get("address").set(address.toModelNode());
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEVELOPMENT: 
                case DISABLED: 
                case KEEP_GENERATED: 
                case TRIM_SPACES: 
                case TAG_POOLING: 
                case MAPPED_FILE: 
                case CHECK_INTERVAL: 
                case MODIFICATION_TEST_INTERVAL: 
                case RECOMPILE_ON_FAIL: 
                case SMAP: 
                case DUMP_SMAP: 
                case GENERATE_STRINGS_AS_CHAR_ARRAYS: 
                case ERROR_ON_USE_BEAN_INVALID_CLASS_ATTRIBUTE: 
                case SCRATCH_DIR: 
                case SOURCE_VM: 
                case TARGET_VM: 
                case JAVA_ENCODING: 
                case X_POWERED_BY: 
                case DISPLAY_SOURCE_FRAGMENT: {
                    WebJSPDefinition.ATTRIBUTES_MAP.get(attribute.getLocalName()).parseAndSetParameter(value, jsp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        list.add(jsp);
    }

    static void parseStaticResources(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.STATIC_RESOURCES_PATH});
        ModelNode resources = new ModelNode();
        resources.get("operation").set("add");
        resources.get("address").set(address.toModelNode());
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LISTINGS: {
                    WebStaticResources.LISTINGS.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                case SENDFILE: {
                    WebStaticResources.SENDFILE.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                case FILE_ENCODING: {
                    WebStaticResources.FILE_ENCODING.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                case READ_ONLY: {
                    WebStaticResources.READ_ONLY.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                case WEBDAV: {
                    WebStaticResources.WEBDAV.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                case SECRET: {
                    WebStaticResources.SECRET.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                case MAX_DEPTH: {
                    WebStaticResources.MAX_DEPTH.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                case DISABLED: {
                    WebStaticResources.DISABLED.parseAndSetParameter(value, resources, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        list.add(resources);
    }

    static void parseHost(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        ModelNode host = new ModelNode();
        int count = reader.getAttributeCount();
        block28: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block28;
                }
                case DEFAULT_WEB_MODULE: {
                    WebVirtualHostDefinition.DEFAULT_WEB_MODULE.parseAndSetParameter(value, host, (XMLStreamReader)reader);
                    continue block28;
                }
                case ENABLE_WELCOME_ROOT: {
                    WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.parseAndSetParameter(value, host, (XMLStreamReader)reader);
                    continue block28;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{PathElement.pathElement((String)"virtual-server", name)});
        host.get("operation").set("add");
        host.get("address").set(address.toModelNode());
        list.add(host);
        int rewriteCount = 0;
        block29: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALIAS: {
                            host.get("alias").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block29;
                        }
                        case ACCESS_LOG: {
                            WebSubsystemParser.parseHostAccessLog(reader, address, list);
                            continue block29;
                        }
                        case REWRITE: {
                            WebSubsystemParser.parseHostRewrite(reader, address, list, ++rewriteCount);
                            continue block29;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case WEB_1_1: 
                case WEB_1_2: 
                case WEB_1_3: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALIAS: {
                            host.get("alias").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block29;
                        }
                        case ACCESS_LOG: {
                            WebSubsystemParser.parseHostAccessLog(reader, address, list);
                            continue block29;
                        }
                        case REWRITE: {
                            WebSubsystemParser.parseHostRewrite(reader, address, list, ++rewriteCount);
                            continue block29;
                        }
                        case SSO: {
                            WebSubsystemParser.parseSso(reader, address, list);
                            continue block29;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case WEB_1_4: 
                case WEB_2_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ALIAS: {
                            host.get("alias").add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName()));
                            continue block29;
                        }
                        case ACCESS_LOG: {
                            WebSubsystemParser.parseHostAccessLog(reader, address, list);
                            continue block29;
                        }
                        case REWRITE: {
                            WebSubsystemParser.parseHostRewrite(reader, address, list, ++rewriteCount);
                            continue block29;
                        }
                        case SSO: {
                            WebSubsystemParser.parseSso(reader, address, list);
                            continue block29;
                        }
                        case VALVE: {
                            WebSubsystemParser.parseValve(reader, address, list);
                            continue block29;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseSso(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.SSO_PATH});
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address.toModelNode());
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE_CONTAINER: {
                    WebSSODefinition.CACHE_CONTAINER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case CACHE_NAME: {
                    WebSSODefinition.CACHE_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case DOMAIN: {
                    WebSSODefinition.DOMAIN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case REAUTHENTICATE: {
                    WebSSODefinition.REAUTHENTICATE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        list.add(operation);
    }

    static void parseHostRewrite(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list, int rewriteCount) throws XMLStreamException {
        ModelNode rewrite = Util.createAddOperation();
        int count = reader.getAttributeCount();
        String name = RULE_PREFIX + rewriteCount;
        block18: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATTERN: {
                    WebReWriteDefinition.PATTERN.parseAndSetParameter(value, rewrite, (XMLStreamReader)reader);
                    continue block18;
                }
                case SUBSTITUTION: {
                    WebReWriteDefinition.SUBSTITUTION.parseAndSetParameter(value, rewrite, (XMLStreamReader)reader);
                    continue block18;
                }
                case FLAGS: {
                    WebReWriteDefinition.FLAGS.parseAndSetParameter(value, rewrite, (XMLStreamReader)reader);
                    continue block18;
                }
                case NAME: {
                    name = value;
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{PathElement.pathElement((String)"rewrite", (String)name)});
        rewrite.get("address").set(address.toModelNode());
        list.add(rewrite);
        int conditionCount = 0;
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: 
                case WEB_1_1: 
                case WEB_1_2: 
                case WEB_1_3: 
                case WEB_1_4: 
                case WEB_2_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONDITION: {
                            ModelNode condition = Util.createAddOperation();
                            String condName = CONDITION_PREFIX + conditionCount;
                            int count2 = reader.getAttributeCount();
                            block20: for (int i = 0; i < count2; ++i) {
                                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                                String value = reader.getAttributeValue(i);
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case NAME: {
                                        condName = value;
                                        continue block20;
                                    }
                                    case TEST: {
                                        WebReWriteConditionDefinition.TEST.parseAndSetParameter(value, condition, (XMLStreamReader)reader);
                                        continue block20;
                                    }
                                    case PATTERN: {
                                        WebReWriteConditionDefinition.PATTERN.parseAndSetParameter(value, condition, (XMLStreamReader)reader);
                                        continue block20;
                                    }
                                    case FLAGS: {
                                        WebReWriteConditionDefinition.FLAGS.parseAndSetParameter(value, condition, (XMLStreamReader)reader);
                                        continue block20;
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            PathAddress condAddress = address.append(new PathElement[]{PathElement.pathElement((String)"condition", (String)condName)});
                            condition.get("address").set(condAddress.toModelNode());
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            list.add(condition);
                            ++conditionCount;
                            continue block19;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseHostAccessLog(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.ACCESS_LOG_PATH});
        ModelNode log = new ModelNode();
        log.get("operation").set("add");
        log.get("address").set(address.toModelNode());
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATTERN: {
                    WebAccessLogDefinition.PATTERN.parseAndSetParameter(value, log, (XMLStreamReader)reader);
                    continue block13;
                }
                case RESOLVE_HOSTS: {
                    WebAccessLogDefinition.RESOLVE_HOSTS.parseAndSetParameter(value, log, (XMLStreamReader)reader);
                    continue block13;
                }
                case EXTENDED: {
                    WebAccessLogDefinition.EXTENDED.parseAndSetParameter(value, log, (XMLStreamReader)reader);
                    continue block13;
                }
                case PREFIX: {
                    WebAccessLogDefinition.PREFIX.parseAndSetParameter(value, log, (XMLStreamReader)reader);
                    continue block13;
                }
                case ROTATE: {
                    WebAccessLogDefinition.ROTATE.parseAndSetParameter(value, log, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(log);
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: 
                case WEB_1_1: 
                case WEB_1_2: 
                case WEB_1_3: 
                case WEB_1_4: 
                case WEB_2_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case DIRECTORY: {
                            WebSubsystemParser.parseDirOrFile(reader, address, list, WebExtension.DIRECTORY_PATH);
                            continue block14;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseConnector(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        ModelNode connector = new ModelNode();
        int count = reader.getAttributeCount();
        block23: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block23;
                }
                case SOCKET_BINDING: {
                    WebConnectorDefinition.SOCKET_BINDING.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case SCHEME: {
                    WebConnectorDefinition.SCHEME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case PROTOCOL: {
                    WebConnectorDefinition.PROTOCOL.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case EXECUTOR: {
                    WebConnectorDefinition.EXECUTOR.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case ENABLED: {
                    WebConnectorDefinition.ENABLED.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case ENABLE_LOOKUPS: {
                    WebConnectorDefinition.ENABLE_LOOKUPS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case PROXY_NAME: {
                    WebConnectorDefinition.PROXY_NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case PROXY_PORT: {
                    WebConnectorDefinition.PROXY_PORT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case MAX_POST_SIZE: {
                    WebConnectorDefinition.MAX_POST_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case MAX_SAVE_POST_SIZE: {
                    WebConnectorDefinition.MAX_SAVE_POST_SIZE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case SECURE: {
                    WebConnectorDefinition.SECURE.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case REDIRECT_PORT: {
                    WebConnectorDefinition.REDIRECT_PORT.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                case MAX_CONNECTIONS: {
                    WebConnectorDefinition.MAX_CONNECTIONS.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block23;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        connector.get("operation").set("add");
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{PathElement.pathElement((String)"connector", name)});
        connector.get("address").set(address.toModelNode());
        list.add(connector);
        block24: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case WEB_1_0: 
                case WEB_1_1: 
                case WEB_1_2: 
                case WEB_1_3: 
                case WEB_1_4: 
                case WEB_2_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SSL: {
                            WebSubsystemParser.parseSsl(reader, address, list);
                            continue block24;
                        }
                        case VIRTUAL_SERVER: {
                            String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                            WebConnectorDefinition.VIRTUAL_SERVER.parseAndAddParameterElement(value, connector, (XMLStreamReader)reader);
                            continue block24;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseSsl(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{WebExtension.SSL_PATH});
        ModelNode ssl = Util.createAddOperation((PathAddress)address);
        int count = reader.getAttributeCount();
        block19: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    WebSSLDefinition.NAME.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case KEY_ALIAS: {
                    WebSSLDefinition.KEY_ALIAS.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case PASSWORD: {
                    WebSSLDefinition.PASSWORD.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case CERTIFICATE_KEY_FILE: {
                    WebSSLDefinition.CERTIFICATE_KEY_FILE.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case CIPHER_SUITE: {
                    WebSSLDefinition.CIPHER_SUITE.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case PROTOCOL: {
                    WebSSLDefinition.PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case VERIFY_CLIENT: {
                    WebSSLDefinition.VERIFY_CLIENT.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case VERIFY_DEPTH: {
                    WebSSLDefinition.VERIFY_DEPTH.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case CERTIFICATE_FILE: {
                    WebSSLDefinition.CERTIFICATE_FILE.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case CA_CERTIFICATE_FILE: {
                    WebSSLDefinition.CA_CERTIFICATE_FILE.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case CA_REVOCATION_URL: {
                    WebSSLDefinition.CA_REVOCATION_URL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case SESSION_CACHE_SIZE: {
                    WebSSLDefinition.SESSION_CACHE_SIZE.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case SESSION_TIMEOUT: {
                    WebSSLDefinition.SESSION_TIMEOUT.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case CA_CERTIFICATE_PASSWORD: {
                    WebSSLDefinition.CA_CERTIFICATE_PASSWORD.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case KEYSTORE_TYPE: {
                    WebSSLDefinition.KEYSTORE_TYPE.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case TRUSTSTORE_TYPE: {
                    WebSSLDefinition.TRUSTSTORE_TYPE.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                case SSL_PROTOCOL: {
                    WebSSLDefinition.SSL_PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block19;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        if (!(namespace != Namespace.WEB_1_1 && namespace != Namespace.WEB_1_0 || ssl.hasDefined(WebSSLDefinition.KEY_ALIAS.getName()))) {
            ssl.get(WebSSLDefinition.KEY_ALIAS.getName()).set("jboss");
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        list.add(ssl);
    }

    private boolean writeAttribute(XMLExtendedStreamWriter writer, SimpleAttributeDefinition attribute, ModelNode node, boolean startWriten, String origin) throws XMLStreamException {
        if (attribute.isMarshallable(node, false)) {
            if (!startWriten) {
                startWriten = true;
                writer.writeStartElement(origin);
            }
            attribute.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        }
        return startWriten;
    }
}

