/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.recovery;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.recovery.HornetQRegistryBase;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.ConcurrentHashSet;

public final class RecoveryManager {
    private HornetQRegistryBase registry;
    private static final String RESOURCE_RECOVERY_CLASS_NAMES = "org.jboss.as.messaging.jms.AS7RecoveryRegistry;org.jboss.as.integration.hornetq.recovery.AS5RecoveryRegistry";
    private final Set<XARecoveryConfig> resources = new ConcurrentHashSet();

    public void start(boolean useAutoRecovery) {
        if (useAutoRecovery) {
            this.locateRecoveryRegistry();
        } else {
            this.registry = null;
        }
    }

    public XARecoveryConfig register(HornetQConnectionFactory factory, String userName, String password) {
        HornetQRALogger.LOGGER.debug("registering recovery for factory : " + factory);
        XARecoveryConfig config = this.newResourceConfig(factory, userName, password);
        this.resources.add(config);
        if (this.registry != null) {
            this.registry.register(config);
        }
        return config;
    }

    private XARecoveryConfig newResourceConfig(HornetQConnectionFactory factory, String userName, String password) {
        if (factory.getServerLocator().getDiscoveryGroupConfiguration() != null) {
            return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getDiscoveryGroupConfiguration(), userName, password);
        }
        return new XARecoveryConfig(factory.getServerLocator().isHA(), factory.getServerLocator().getStaticTransportConfigurations(), userName, password);
    }

    public void unRegister(XARecoveryConfig resourceRecovery) {
        if (this.registry != null) {
            this.registry.unRegister(resourceRecovery);
        }
    }

    public void stop() {
        if (this.registry != null) {
            for (XARecoveryConfig recovery : this.resources) {
                this.registry.unRegister(recovery);
            }
            this.registry.stop();
        }
        this.resources.clear();
    }

    private void locateRecoveryRegistry() {
        String[] locatorClasses;
        for (String locatorClasse : locatorClasses = RESOURCE_RECOVERY_CLASS_NAMES.split(";")) {
            try {
                this.registry = (HornetQRegistryBase)RecoveryManager.safeInitNewInstance(locatorClasse);
            }
            catch (Throwable e) {
                HornetQRALogger.LOGGER.debug("unable to load  recovery registry " + locatorClasse, e);
            }
            if (this.registry != null) break;
        }
        if (this.registry != null) {
            HornetQRALogger.LOGGER.debug("Recovery Registry located = " + this.registry);
        }
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    public Set<XARecoveryConfig> getResources() {
        return this.resources;
    }
}

