/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.MountType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.wildfly.security.manager.GetAccessControlContextAction;

public interface DeploymentMountProvider {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"deployment-mount-provider"});

    public Closeable mountDeploymentContent(VirtualFile var1, VirtualFile var2, MountType var3) throws IOException;

    public static class Factory {
        public static void addService(ServiceTarget serviceTarget) {
            serviceTarget.addService(SERVICE_NAME, (Service)new ServerDeploymentRepositoryImpl()).install();
        }

        private static class ServerDeploymentRepositoryImpl
        implements DeploymentMountProvider,
        Service<DeploymentMountProvider> {
            private volatile TempFileProvider tempFileProvider;

            private ServerDeploymentRepositoryImpl() {
            }

            @Override
            public Closeable mountDeploymentContent(VirtualFile contents, VirtualFile mountPoint, MountType type) throws IOException {
                assert (contents != null) : "null contents";
                switch (type) {
                    case ZIP: {
                        return VFS.mountZip((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
                    }
                    case EXPANDED: {
                        return VFS.mountZipExpanded((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
                    }
                    case REAL: {
                        return VFS.mountReal((File)contents.getPhysicalFile(), (VirtualFile)mountPoint);
                    }
                }
                throw ServerMessages.MESSAGES.unknownMountType(type);
            }

            public void start(StartContext context) throws StartException {
                try {
                    JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("ServerDeploymentRepository-temp-threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
                    this.tempFileProvider = TempFileProvider.create((String)"temp", (ScheduledExecutorService)Executors.newScheduledThreadPool(2, (ThreadFactory)threadFactory));
                }
                catch (IOException e) {
                    throw ServerMessages.MESSAGES.failedCreatingTempProvider();
                }
                ServerLogger.ROOT_LOGGER.debugf("%s started", DeploymentMountProvider.class.getSimpleName());
            }

            public void stop(StopContext context) {
                VFSUtils.safeClose((Closeable)this.tempFileProvider);
                ServerLogger.ROOT_LOGGER.debugf("%s stopped", DeploymentMountProvider.class.getSimpleName());
            }

            public DeploymentMountProvider getValue() throws IllegalStateException {
                return this;
            }
        }
    }
}

