/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class WeldClassIntrospector
implements EEClassIntrospector,
Service<EEClassIntrospector> {
    private static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"weld", "weldClassIntrospector"});
    private final InjectedValue<BeanManager> beanManager = new InjectedValue();
    private final ConcurrentMap<Class<?>, InjectionTarget<?>> injectionTargets = new ConcurrentHashMap();

    public static void install(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) {
        WeldClassIntrospector introspector = new WeldClassIntrospector();
        serviceTarget.addService(WeldClassIntrospector.serviceName(deploymentUnit), (Service)introspector).addDependency(BeanManagerService.serviceName(deploymentUnit), BeanManager.class, introspector.beanManager).install();
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(SERVICE_NAME);
    }

    public ManagedReferenceFactory createFactory(Class<?> clazz) {
        final BeanManager beanManager = (BeanManager)this.beanManager.getValue();
        final InjectionTarget injectionTarget = this.getInjectionTarget(clazz);
        return new ManagedReferenceFactory(){

            public ManagedReference getReference() {
                final CreationalContext context = beanManager.createCreationalContext(null);
                final Object instance = injectionTarget.produce(context);
                injectionTarget.inject(instance, context);
                injectionTarget.postConstruct(instance);
                return new ManagedReference(){

                    public void release() {
                        context.release();
                    }

                    public Object getInstance() {
                        return instance;
                    }
                };
            }
        };
    }

    private InjectionTarget getInjectionTarget(Class<?> clazz) {
        InjectionTarget target = (InjectionTarget)this.injectionTargets.get(clazz);
        if (target != null) {
            return target;
        }
        BeanManager beanManager = (BeanManager)this.beanManager.getValue();
        InjectionTarget newTarget = beanManager.createInjectionTarget(beanManager.createAnnotatedType(clazz));
        target = this.injectionTargets.putIfAbsent(clazz, newTarget);
        if (target == null) {
            return newTarget;
        }
        return target;
    }

    public ManagedReference createInstance(final Object instance) {
        BeanManager beanManager = (BeanManager)this.beanManager.getValue();
        InjectionTarget injectionTarget = this.getInjectionTarget(instance.getClass());
        final CreationalContext context = beanManager.createCreationalContext(null);
        injectionTarget.inject(instance, context);
        injectionTarget.postConstruct(instance);
        return new ManagedReference(){

            public void release() {
                context.release();
            }

            public Object getInstance() {
                return instance;
            }
        };
    }

    public InjectedValue<BeanManager> getBeanManager() {
        return this.beanManager;
    }

    public void start(StartContext startContext) throws StartException {
    }

    public void stop(StopContext stopContext) {
        this.injectionTargets.clear();
    }

    public EEClassIntrospector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

