/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Type;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.weld.services.bootstrap.ManagedReferenceFactoryToResourceReferenceFactoryAdapter;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractResourceInjectionServices {
    protected final ServiceRegistry serviceRegistry;
    protected final EEModuleDescription moduleDescription;

    protected AbstractResourceInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription) {
        this.serviceRegistry = serviceRegistry;
        this.moduleDescription = moduleDescription;
    }

    protected abstract ContextNames.BindInfo getBindInfo(String var1);

    protected ManagedReferenceFactory getManagedReferenceFactory(ContextNames.BindInfo ejbBindInfo) {
        try {
            ServiceController controller = this.serviceRegistry.getRequiredService(ejbBindInfo.getBinderServiceName());
            return (ManagedReferenceFactory)controller.getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ResourceReferenceFactory<Object> handleServiceLookup(String result, InjectionPoint injectionPoint) {
        ContextNames.BindInfo ejbBindInfo = this.getBindInfo(result);
        ManagedReferenceFactory factory = this.getManagedReferenceFactory(ejbBindInfo);
        if (factory instanceof ContextListManagedReferenceFactory && injectionPoint != null) {
            AbstractResourceInjectionServices.validateResourceInjectionPointType((ContextListManagedReferenceFactory)factory, injectionPoint);
        }
        if (factory != null) {
            return new ManagedReferenceFactoryToResourceReferenceFactoryAdapter<Object>(factory);
        }
        return this.createLazyResourceReferenceFactory(ejbBindInfo);
    }

    protected static void validateResourceInjectionPointType(ContextListManagedReferenceFactory factory, InjectionPoint injectionPoint) {
        Class resourceClass = org.jboss.as.weld.util.Reflections.loadClass(factory.getInstanceClassName(), factory.getClass().getClassLoader());
        if (resourceClass == null) {
            resourceClass = org.jboss.as.weld.util.Reflections.loadClass(factory.getInstanceClassName(), WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
        }
        if (resourceClass != null) {
            AbstractResourceInjectionServices.validateResourceInjectionPointType(resourceClass, injectionPoint);
        }
    }

    protected static void validateResourceInjectionPointType(Class<?> resourceType, InjectionPoint injectionPoint) {
        Class injectionPointRawType = Reflections.getRawType((Type)injectionPoint.getType());
        HierarchyDiscovery discovery = new HierarchyDiscovery(resourceType);
        for (Type type : discovery.getTypeClosure()) {
            if (!Reflections.getRawType((Type)type).equals(injectionPointRawType)) continue;
            return;
        }
        throw new DefinitionException((Enum)BeanMessage.INVALID_RESOURCE_PRODUCER_TYPE, new Object[]{injectionPoint.getAnnotated(), resourceType.getName()});
    }

    protected ResourceReferenceFactory<Object> createLazyResourceReferenceFactory(final ContextNames.BindInfo ejbBindInfo) {
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                ManagedReferenceFactory factory = AbstractResourceInjectionServices.this.getManagedReferenceFactory(ejbBindInfo);
                if (factory == null) {
                    return new SimpleResourceReference(null);
                }
                final ManagedReference instance = factory.getReference();
                return new ResourceReference<Object>(){

                    public Object getInstance() {
                        return instance.getInstance();
                    }

                    public void release() {
                        instance.release();
                    }
                };
            }
        };
    }
}

