/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.resources;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.IOException;
import java.io.PrintWriter;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;

public class ResourceRecord
extends AbstractRecord {
    private Coordinator _parentCoordHandle;
    private Resource _resourceHandle;
    private String _stringifiedResourceHandle;
    private Uid _recCoordUid;
    private boolean _propagateRecord;
    private boolean _committed;
    private boolean _rolledback;

    public ResourceRecord(boolean propagate, Resource theResource, Coordinator myParent, Uid recCoordUid, ArjunaTransactionImple current) {
        super(new Uid(), null, 1);
        this._parentCoordHandle = myParent;
        this._resourceHandle = theResource;
        this._stringifiedResourceHandle = null;
        this._recCoordUid = recCoordUid != null ? new Uid(recCoordUid) : Uid.nullUid();
        this._propagateRecord = propagate;
        this._committed = false;
        this._rolledback = false;
    }

    public final Resource resourceHandle() {
        block8: {
            if (this._resourceHandle == null && this._stringifiedResourceHandle != null) {
                try {
                    ORB theOrb = ORBManager.getORB().orb();
                    if (theOrb == null) {
                        throw new UNKNOWN();
                    }
                    if (jtsLogger.logger.isTraceEnabled()) {
                        jtsLogger.logger.trace((java.lang.Object)("ResourceRecord: About to string_to_object on " + this._stringifiedResourceHandle));
                    }
                    Object optr = theOrb.string_to_object(this._stringifiedResourceHandle);
                    if (jtsLogger.logger.isTraceEnabled()) {
                        jtsLogger.logger.trace((java.lang.Object)"ResourceRecord: Successfully stringed to object, next try to narrow");
                    }
                    theOrb = null;
                    this._resourceHandle = ResourceHelper.narrow(optr);
                    if (jtsLogger.logger.isTraceEnabled()) {
                        jtsLogger.logger.trace((java.lang.Object)"ResourceRecord: Successfully narrowed");
                    }
                    if (this._resourceHandle == null) {
                        throw new BAD_PARAM();
                    }
                    java.lang.Object var2_3 = null;
                }
                catch (SystemException e) {
                    if (!jtsLogger.logger.isTraceEnabled()) break block8;
                    jtsLogger.logger.trace((java.lang.Object)"ResourceRecord: Failed to narrow to Resource");
                }
            }
        }
        return this._resourceHandle;
    }

    @Override
    public boolean propagateOnCommit() {
        return this._propagateRecord;
    }

    @Override
    public int typeIs() {
        return 141;
    }

    @Override
    public java.lang.Object value() {
        return this._resourceHandle;
    }

    @Override
    public void setValue(java.lang.Object o) {
        jtsLogger.i18NLogger.warn_resources_rrillegalvalue("ResourceRecord.set_value");
    }

    @Override
    public int nestedAbort() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ResourceRecord::nestedAbort() for " + this.order()));
        }
        SubtransactionAwareResource staResource = null;
        int o = 8;
        try {
            staResource = SubtransactionAwareResourceHelper.narrow(this.resourceHandle());
            if (staResource == null) {
                throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
            }
        }
        catch (Exception exEnv) {
            o = 7;
        }
        if (staResource != null) {
            try {
                staResource.rollback_subtransaction();
                o = 7;
            }
            catch (Exception e) {
                o = 8;
            }
            staResource = null;
        }
        this._parentCoordHandle = null;
        return o;
    }

    @Override
    public int nestedCommit() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ResourceRecord::nestedCommit() for " + this.order()));
        }
        return 7;
    }

    @Override
    public int nestedPrepare() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ResourceRecord::nestedPrepare() for " + this.order()));
        }
        int o = 10;
        SubtransactionAwareResource staResource = null;
        try {
            if (this._committed) {
                return 0;
            }
            this._committed = true;
            staResource = SubtransactionAwareResourceHelper.narrow(this.resourceHandle());
            if (staResource == null) {
                throw new BAD_PARAM(0, CompletionStatus.COMPLETED_NO);
            }
        }
        catch (Exception e) {
            o = 0;
        }
        if (staResource != null) {
            try {
                staResource.commit_subtransaction(this._parentCoordHandle);
                o = 0;
                staResource = null;
            }
            catch (Exception e) {
                o = 10;
            }
        }
        this._parentCoordHandle = null;
        return o;
    }

    @Override
    public int topLevelAbort() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ResourceRecord::topLevelAbort() for " + this.order()));
        }
        try {
            if (this.resourceHandle() == null) {
                return 8;
            }
            this._resourceHandle.rollback();
        }
        catch (HeuristicCommit exEnv) {
            if (this._rolledback) {
                return 6;
            }
            return 4;
        }
        catch (HeuristicMixed ex1) {
            return 5;
        }
        catch (HeuristicHazard ex2) {
            return 6;
        }
        catch (OBJECT_NOT_EXIST one) {
            if (this._rolledback) {
                return 7;
            }
            return 6;
        }
        catch (SystemException ex3) {
            jtsLogger.i18NLogger.warn_resources_rrcaught("ResourceRecord.topLevelAbort", ex3);
            return 8;
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ResourceRecord::topLevelCommit() for " + this.order()));
        }
        try {
            if (this.resourceHandle() == null) {
                return 8;
            }
            this._resourceHandle.commit();
        }
        catch (NotPrepared ex1) {
            return 9;
        }
        catch (HeuristicRollback ex2) {
            return 3;
        }
        catch (HeuristicMixed ex3) {
            return 5;
        }
        catch (HeuristicHazard ex4) {
            return 6;
        }
        catch (SystemException ex5) {
            jtsLogger.i18NLogger.warn_resources_rrcaught("ResourceRecord commit -", ex5);
            return 8;
        }
        return 7;
    }

    @Override
    public int topLevelPrepare() {
        block11: {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace((java.lang.Object)("ResourceRecord::topLevelPrepare() for " + this.order()));
            }
            try {
                if (this.resourceHandle() != null) {
                    switch (this._resourceHandle.prepare().value()) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            this._rolledback = true;
                            return 1;
                        }
                        case 2: {
                            return 2;
                        }
                    }
                    break block11;
                }
                return 1;
            }
            catch (HeuristicMixed ex) {
                return 5;
            }
            catch (HeuristicHazard ex) {
                return 6;
            }
            catch (Exception e) {
                return 1;
            }
        }
        return 1;
    }

    @Override
    public int nestedOnePhaseCommit() {
        int res = this.nestedPrepare();
        switch (res) {
            case 0: {
                return this.nestedCommit();
            }
            case 2: {
                return 7;
            }
        }
        return 8;
    }

    @Override
    public int topLevelOnePhaseCommit() {
        try {
            if (this.resourceHandle() != null) {
                this._resourceHandle.commit_one_phase();
            }
        }
        catch (HeuristicHazard e1) {
            return 6;
        }
        catch (TRANSACTION_ROLLEDBACK e4) {
            return 10;
        }
        catch (INVALID_TRANSACTION e5) {
            return 10;
        }
        catch (Exception e5) {
            return 6;
        }
        return 7;
    }

    @Override
    public boolean forgetHeuristic() {
        try {
            if (this.resourceHandle() != null) {
                this._resourceHandle.forget();
                return true;
            }
            jtsLogger.i18NLogger.warn_resources_rrinvalid("ResourceRecord.forgetHeuristic");
        }
        catch (SystemException e) {
            jtsLogger.i18NLogger.warn_resources_rrcaught("ResourceRecord.forgetHeuristic", e);
        }
        return false;
    }

    public static AbstractRecord create() {
        return new ResourceRecord();
    }

    public static void remove(AbstractRecord toDelete) {
    }

    @Override
    public void print(PrintWriter strm) {
        super.print(strm);
        strm.print("Resource Record");
        strm.print(this._resourceHandle + "\t" + this._parentCoordHandle + "\t" + this._propagateRecord);
    }

    @Override
    public boolean restore_state(InputObjectState os, int t) {
        int isString = 0;
        boolean result = super.restore_state(os, t);
        if (!result) {
            return false;
        }
        try {
            isString = os.unpackInt();
            this._parentCoordHandle = null;
            if (isString == 1) {
                this._stringifiedResourceHandle = os.unpackString();
                this._recCoordUid = UidHelper.unpackFrom(os);
                if (jtsLogger.logger.isTraceEnabled()) {
                    jtsLogger.logger.trace((java.lang.Object)("ResourceRecord.restore_state: unpacked rec co with uid=" + this._recCoordUid));
                }
            }
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean save_state(OutputObjectState os, int t) {
        boolean result = super.save_state(os, t);
        if (!result) {
            return false;
        }
        try {
            if (this.resourceHandle() == null && this._stringifiedResourceHandle == null) {
                os.packInt(-1);
            } else {
                os.packInt(1);
                String stringRef = null;
                if (this._resourceHandle != null) {
                    ORB theOrb = ORBManager.getORB().orb();
                    if (theOrb == null) {
                        throw new UNKNOWN();
                    }
                    stringRef = theOrb.object_to_string((Object)this._resourceHandle);
                    theOrb = null;
                } else {
                    stringRef = this._stringifiedResourceHandle;
                }
                if (stringRef != null) {
                    os.packString(stringRef);
                    if (jtsLogger.logger.isTraceEnabled()) {
                        jtsLogger.logger.trace((java.lang.Object)("ResourceRecord: packed obj ref " + stringRef));
                    }
                } else {
                    result = false;
                }
                stringRef = null;
                if (result) {
                    UidHelper.packInto(this._recCoordUid, os);
                    if (jtsLogger.logger.isTraceEnabled()) {
                        jtsLogger.logger.trace((java.lang.Object)("Packed rec co uid of " + this._recCoordUid));
                    }
                }
            }
        }
        catch (IOException e) {
            result = false;
        }
        catch (SystemException e) {
            result = false;
        }
        return result;
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/ResourceRecord";
    }

    @Override
    public boolean doSave() {
        return true;
    }

    public final Uid getRCUid() {
        return this._recCoordUid;
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord rec) {
        boolean replace = false;
        if (rec != null && rec.typeIs() == this.typeIs()) {
            ResourceRecord newRec = (ResourceRecord)rec;
            if (this._recCoordUid.notEquals(Uid.nullUid()) && this._recCoordUid.equals(newRec.getRCUid())) {
                replace = true;
            }
        }
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((java.lang.Object)("ResourceRecord: shouldReplace() = " + replace));
        }
        return replace;
    }

    public ResourceRecord(boolean propagate, Resource theResource, Uid recCoordUid) {
        super(new Uid(), null, 1);
        this._parentCoordHandle = null;
        this._resourceHandle = theResource;
        this._stringifiedResourceHandle = null;
        this._recCoordUid = recCoordUid != null ? new Uid(recCoordUid) : Uid.nullUid();
        this._propagateRecord = propagate;
        this._committed = false;
        this._rolledback = false;
    }

    public ResourceRecord() {
        this._parentCoordHandle = null;
        this._resourceHandle = null;
        this._stringifiedResourceHandle = null;
        this._recCoordUid = new Uid(Uid.nullUid());
        this._propagateRecord = false;
        this._committed = false;
        this._rolledback = false;
    }
}

