/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.jmx.AuditLoggerInfo;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.MBeanServerAuditLogger;
import org.jboss.as.jmx.model.ModelControllerMBeanServerPlugin;
import org.jboss.as.server.jmx.MBeanServerPlugin;
import org.jboss.as.server.jmx.PluggableMBeanServer;
import org.wildfly.security.manager.WildFlySecurityManager;

class PluggableMBeanServerImpl
implements PluggableMBeanServer {
    private final MBeanServer rootMBeanServer;
    private volatile AuditLoggerInfo auditLoggerInfo = NOOP_INFO;
    private final Set<MBeanServerPlugin> delegates = new CopyOnWriteArraySet<MBeanServerPlugin>();
    private static final AuditLoggerInfo NOOP_INFO = new AuditLoggerInfo(AuditLogger.NO_OP_LOGGER);

    PluggableMBeanServerImpl(MBeanServer rootMBeanServer) {
        this.rootMBeanServer = new TcclMBeanServer(rootMBeanServer);
    }

    void setAuditLogger(AuditLoggerInfo auditLoggerInfo) {
        this.auditLoggerInfo = auditLoggerInfo != null ? auditLoggerInfo : NOOP_INFO;
    }

    AuditLogger getAuditLogger() {
        return this.auditLoggerInfo.getAuditLogger();
    }

    boolean isBooting() {
        return this.auditLoggerInfo.isBooting();
    }

    boolean shouldLog(boolean readOnly) {
        return this.auditLoggerInfo.shouldLog(readOnly);
    }

    public void addPlugin(MBeanServerPlugin delegate) {
        this.delegates.add(delegate);
    }

    public void removePlugin(MBeanServerPlugin delegate) {
        this.delegates.remove(delegate);
    }

    private MBeanServer findDelegate(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            throw JmxMessages.MESSAGES.objectNameCantBeNull();
        }
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                if (!delegate.accepts(name) || !delegate.isRegistered(name)) continue;
                return delegate;
            }
        }
        if (this.rootMBeanServer.isRegistered(name)) {
            return this.rootMBeanServer;
        }
        throw new InstanceNotFoundException(name.toString());
    }

    private boolean shouldLog(ObjectName name) {
        if (name == null) {
            return false;
        }
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                if (!delegate.accepts(name)) continue;
                return !(delegate instanceof ModelControllerMBeanServerPlugin);
            }
        }
        return false;
    }

    private MBeanServer findDelegateForNewObject(ObjectName name) {
        if (name == null) {
            throw JmxMessages.MESSAGES.objectNameCantBeNull();
        }
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                if (!delegate.accepts(name)) continue;
                return delegate;
            }
        }
        return this.rootMBeanServer;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Exception error = null;
        try {
            this.findDelegate(name).addNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).addNotificationListener(name, listener, filter, handback);
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Exception error = null;
        try {
            this.findDelegate(name).addNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).addNotificationListener(name, listener, filter, handback);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        Exception error = null;
        try {
            ObjectInstance objectInstance = this.findDelegateForNewObject(name).createMBean(className, name, params, signature);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).createMBean(className, name, params, signature);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Exception error = null;
        try {
            ObjectInstance objectInstance = this.findDelegate(name).createMBean(className, name, loaderName, params, signature);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).createMBean(className, name, params, signature);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Exception error = null;
        try {
            ObjectInstance objectInstance = this.findDelegate(name).createMBean(className, name, loaderName);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).createMBean(className, name, loaderName);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        Exception error = null;
        try {
            ObjectInstance objectInstance = this.findDelegateForNewObject(name).createMBean(className, name);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).createMBean(className, name);
        }
    }

    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        Exception error = null;
        try {
            ObjectInputStream objectInputStream = this.findDelegate(name).deserialize(name, data);
            return objectInputStream;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof OperationsException) {
                throw (OperationsException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).deserialize(name, data);
        }
    }

    @Deprecated
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        Exception error = null;
        try {
            ObjectInputStream objectInputStream = this.rootMBeanServer.deserialize(className, data);
            return objectInputStream;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof OperationsException) {
                throw (OperationsException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).deserialize(className, data);
        }
    }

    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        Exception error = null;
        try {
            ObjectInputStream objectInputStream = this.rootMBeanServer.deserialize(className, loaderName, data);
            return objectInputStream;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof OperationsException) {
                throw (OperationsException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).deserialize(className, loaderName, data);
        }
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Exception error = null;
        try {
            Object object = this.findDelegate(name).getAttribute(name, attribute);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getAttribute(name, attribute);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        Exception error = null;
        try {
            AttributeList attributeList = this.findDelegate(name).getAttributes(name, attributes);
            return attributeList;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getAttributes(name, attributes);
        }
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        Exception error = null;
        try {
            ClassLoader classLoader = this.findDelegate(loaderName).getClassLoader(loaderName);
            return classLoader;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getClassLoader(loaderName);
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        Exception error = null;
        try {
            ClassLoader classLoader = this.findDelegate(mbeanName).getClassLoaderFor(mbeanName);
            return classLoader;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getClassLoaderFor(mbeanName);
        }
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        Exception error = null;
        try {
            ClassLoaderRepository classLoaderRepository = this.rootMBeanServer.getClassLoaderRepository();
            return classLoaderRepository;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getClassLoaderRepository();
        }
    }

    public String getDefaultDomain() {
        Exception error = null;
        try {
            String string = this.rootMBeanServer.getDefaultDomain();
            return string;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getDefaultDomain();
        }
    }

    public String[] getDomains() {
        Exception error = null;
        try {
            ArrayList<String> result = new ArrayList<String>();
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    String[] domains = delegate.getDomains();
                    if (domains.length <= 0) continue;
                    result.addAll(Arrays.asList(domains));
                }
            }
            result.addAll(Arrays.asList(this.rootMBeanServer.getDomains()));
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getDomains();
        }
    }

    public Integer getMBeanCount() {
        Exception error = null;
        try {
            int i = 0;
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    i += delegate.getMBeanCount().intValue();
                }
            }
            Integer n = i += this.rootMBeanServer.getMBeanCount().intValue();
            return n;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getMBeanCount();
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getMBeanInfo(name, true, false);
    }

    MBeanInfo getMBeanInfo(ObjectName name, boolean log, boolean nullIfNotFound) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Exception error = null;
        try {
            MBeanInfo mBeanInfo = this.findDelegate(name).getMBeanInfo(name);
            return mBeanInfo;
        }
        catch (Exception e) {
            if (nullIfNotFound) {
                MBeanInfo mBeanInfo = null;
                return mBeanInfo;
            }
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IntrospectionException) {
                throw (IntrospectionException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (log) {
                new MBeanServerAuditLogger(this, error).getMBeanInfo(name);
            }
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        Exception error = null;
        try {
            ObjectInstance objectInstance = this.findDelegate(name).getObjectInstance(name);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).getObjectInstance(name);
        }
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        Exception error = null;
        try {
            Object object = this.rootMBeanServer.instantiate(className, params, signature);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).instantiate(className, params, signature);
        }
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Exception error = null;
        try {
            Object object = this.rootMBeanServer.instantiate(className, loaderName, params, signature);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).instantiate(className, loaderName, params, signature);
        }
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Exception error = null;
        try {
            Object object = this.rootMBeanServer.instantiate(className, loaderName);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).instantiate(className, loaderName);
        }
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        Exception error = null;
        try {
            Object object = this.rootMBeanServer.instantiate(className);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).instantiate(className);
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Exception error = null;
        try {
            Object object = this.findDelegate(name).invoke(name, operationName, params, signature);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).invoke(name, operationName, params, signature);
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        Exception error = null;
        try {
            boolean bl = this.findDelegate(name).isInstanceOf(name, className);
            return bl;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).isInstanceOf(name, className);
        }
    }

    public boolean isRegistered(ObjectName name) {
        Exception error = null;
        try {
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    if (!delegate.accepts(name) || !delegate.isRegistered(name)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean i$ = this.rootMBeanServer.isRegistered(name);
            return i$;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).isRegistered(name);
        }
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        Exception error = null;
        try {
            HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    if (name != null && (name.getDomain() == null || !delegate.accepts(name))) continue;
                    result.addAll(delegate.queryMBeans(name, query));
                }
            }
            result.addAll(this.rootMBeanServer.queryMBeans(name, query));
            HashSet<ObjectInstance> hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).queryMBeans(name, query);
        }
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        Exception error = null;
        try {
            HashSet<ObjectName> result = new HashSet<ObjectName>();
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    if (name != null && (name.getDomain() == null || !delegate.accepts(name))) continue;
                    result.addAll(delegate.queryNames(name, query));
                }
            }
            result.addAll(this.rootMBeanServer.queryNames(name, query));
            HashSet<ObjectName> hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).queryNames(name, query);
        }
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Exception error = null;
        try {
            ObjectInstance objectInstance = this.findDelegateForNewObject(name).registerMBean(object, name);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).registerMBean(object, name);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        try {
            this.findDelegate(name).removeNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).removeNotificationListener(name, listener, filter, handback);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        try {
            this.findDelegate(name).removeNotificationListener(name, listener);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).removeNotificationListener(name, listener);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        try {
            this.findDelegate(name).removeNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).removeNotificationListener(name, listener, filter, handback);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        try {
            this.findDelegate(name).removeNotificationListener(name, listener);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).removeNotificationListener(name, listener);
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Exception error = null;
        try {
            this.findDelegate(name).setAttribute(name, attribute);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).setAttribute(name, attribute);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        Exception error = null;
        try {
            AttributeList attributeList = this.findDelegate(name).setAttributes(name, attributes);
            return attributeList;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).setAttributes(name, attributes);
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        Exception error = null;
        try {
            this.findDelegate(name).unregisterMBean(name);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogger(this, error).unregisterMBean(name);
        }
    }

    private RuntimeException makeRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private class TcclMBeanServer
    implements MBeanServer {
        private final MBeanServer delegate;

        public TcclMBeanServer(MBeanServer delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.addNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.addNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
            return this.delegate.createMBean(className, name, params, signature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                ObjectInstance objectInstance = this.delegate.createMBean(className, name, loaderName, params, signature);
                return objectInstance;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                ObjectInstance objectInstance = this.delegate.createMBean(className, name, loaderName);
                return objectInstance;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
            return this.delegate.createMBean(className, name);
        }

        @Override
        @Deprecated
        public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
            return this.delegate.deserialize(name, data);
        }

        @Override
        @Deprecated
        public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
            return this.delegate.deserialize(className, data);
        }

        @Override
        @Deprecated
        public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
            return this.delegate.deserialize(className, loaderName, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                Object object = this.delegate.getAttribute(name, attribute);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                AttributeList attributeList = this.delegate.getAttributes(name, attributes);
                return attributeList;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
            return this.delegate.getClassLoader(loaderName);
        }

        @Override
        public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
            return this.delegate.getClassLoaderFor(mbeanName);
        }

        @Override
        public ClassLoaderRepository getClassLoaderRepository() {
            return this.delegate.getClassLoaderRepository();
        }

        @Override
        public String getDefaultDomain() {
            return this.delegate.getDefaultDomain();
        }

        @Override
        public String[] getDomains() {
            return this.delegate.getDomains();
        }

        @Override
        public Integer getMBeanCount() {
            return this.delegate.getMBeanCount();
        }

        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
            return this.delegate.getMBeanInfo(name);
        }

        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
            return this.delegate.getObjectInstance(name);
        }

        @Override
        public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
            return this.delegate.instantiate(className, params, signature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                Object object = this.delegate.instantiate(className, loaderName, params, signature);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                Object object = this.delegate.instantiate(className, loaderName);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public Object instantiate(String className) throws ReflectionException, MBeanException {
            return this.delegate.instantiate(className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                Object object = this.delegate.invoke(name, operationName, params, signature);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
            return this.delegate.isInstanceOf(name, className);
        }

        @Override
        public boolean isRegistered(ObjectName name) {
            return this.delegate.isRegistered(name);
        }

        @Override
        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
            return this.delegate.queryMBeans(name, query);
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
            return this.delegate.queryNames(name, query);
        }

        @Override
        public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
            return this.delegate.registerMBean(object, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.setAttribute(name, attribute);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                AttributeList attributeList = this.delegate.setAttributes(name, attributes);
                return attributeList;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
            this.delegate.unregisterMBean(name);
        }

        private ClassLoader pushClassLoader(ObjectName name) throws InstanceNotFoundException {
            ClassLoader mbeanCl = this.delegate.getClassLoaderFor(name);
            return WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)mbeanCl);
        }

        private ClassLoader pushClassLoaderByName(ObjectName loaderName) throws InstanceNotFoundException {
            ClassLoader mbeanCl = this.delegate.getClassLoader(loaderName);
            return WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)mbeanCl);
        }

        private void resetClassLoader(ClassLoader cl) {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }
}

