/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jboss.as.clustering.infinispan.io.AbstractSimpleExternalizer;
import org.wildfly.clustering.server.SimpleNode;

public class SimpleNodeExternalizer
extends AbstractSimpleExternalizer<SimpleNode> {
    private static final long serialVersionUID = 7862205227654119771L;

    public SimpleNodeExternalizer() {
        super(SimpleNode.class);
    }

    public void writeObject(ObjectOutput output, SimpleNode node) throws IOException {
        output.writeUTF(node.getName());
        InetSocketAddress socketAddress = node.getSocketAddress();
        byte[] address = socketAddress.getAddress().getAddress();
        output.writeInt(address.length);
        output.write(address);
        output.writeInt(node.getSocketAddress().getPort());
    }

    public SimpleNode readObject(ObjectInput input) throws IOException {
        String name = input.readUTF();
        byte[] address = new byte[input.readInt()];
        input.readFully(address);
        int port = input.readInt();
        return new SimpleNode(name, new InetSocketAddress(InetAddress.getByAddress(address), port));
    }
}

