/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.Arrays;
import java.util.Collection;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.invoker.BatchCacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.ChannelDependentServiceProvider;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryProvider;
import org.wildfly.clustering.server.service.ServiceProviderRegistryFactoryService;
import org.wildfly.clustering.service.ServiceProviderRegistry;

public class ServiceProviderRegistryFactoryProvider
implements ChannelDependentServiceProvider {
    private static final Logger logger = Logger.getLogger(CommandDispatcherFactoryProvider.class);

    private static ServiceName getServiceName(String cluster) {
        return ServiceProviderRegistry.SERVICE_NAME.append(new String[]{cluster});
    }

    public Collection<ServiceName> getServiceNames(String cluster) {
        return Arrays.asList(ServiceProviderRegistryFactoryProvider.getServiceName(cluster), ServiceProviderRegistryFactoryProvider.createBinding(cluster).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String cluster, ModuleIdentifier moduleId) {
        ServiceName name = ServiceProviderRegistryFactoryProvider.getServiceName(cluster);
        ContextNames.BindInfo bindInfo = ServiceProviderRegistryFactoryProvider.createBinding(cluster);
        logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceController binderController = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindInfo.getBindName()})}).addDependency(name, ServiceProviderRegistry.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
        InjectedValue cache = new InjectedValue();
        InjectedValue dispatcherFactory = new InjectedValue();
        BatchCacheInvoker invoker = new BatchCacheInvoker();
        ServiceController controller = target.addService(name, (Service)new ServiceProviderRegistryFactoryService(name, (Value<Cache>)cache, (Value<CommandDispatcherFactory>)dispatcherFactory, (CacheInvoker)invoker)).addDependency(CacheService.getServiceName((String)cluster, null), Cache.class, (Injector)cache).addDependency(CommandDispatcherFactory.SERVICE_NAME.append(new String[]{cluster}), CommandDispatcherFactory.class, (Injector)dispatcherFactory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return Arrays.asList(controller, binderController);
    }

    private static ContextNames.BindInfo createBinding(String cluster) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "registry", cluster}).getAbsoluteName());
    }
}

