/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.Node;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.dispatcher.MembershipListener;
import org.wildfly.clustering.server.service.ServiceProvider;
import org.wildfly.clustering.server.service.ServiceProviderCommand;
import org.wildfly.clustering.service.ServiceProviderRegistration;
import org.wildfly.clustering.service.ServiceProviderRegistry;

@Listener
public class ServiceProviderRegistryFactoryService
implements ServiceProviderRegistry,
ServiceProvider,
MembershipListener,
Service<ServiceProviderRegistry> {
    private final ServiceName name;
    private final Value<Cache> cacheRef;
    final Value<CommandDispatcherFactory> dispatcherFactory;
    final ConcurrentMap<ServiceName, ServiceProviderRegistration.Listener> listeners = new ConcurrentHashMap<ServiceName, ServiceProviderRegistration.Listener>();
    final CacheInvoker invoker;
    private volatile CommandDispatcher<ServiceProvider> dispatcher;
    volatile Cache<ServiceName, Set<Node>> cache;

    public ServiceProviderRegistryFactoryService(ServiceName name, Value<Cache> cacheRef, Value<CommandDispatcherFactory> dispatcherFactory, CacheInvoker invoker) {
        this.name = name;
        this.cacheRef = cacheRef;
        this.dispatcherFactory = dispatcherFactory;
        this.invoker = invoker;
    }

    public ServiceProviderRegistration createRegistration(final ServiceName service, ServiceProviderRegistration.Listener listener) {
        if (this.listeners.putIfAbsent(service, listener) != null) {
            throw new IllegalArgumentException(service.getCanonicalName());
        }
        final Node node = ((CommandDispatcherFactory)this.dispatcherFactory.getValue()).getLocalNode();
        Operation<Set<Node>> operation = new Operation<Set<Node>>(){

            public Set<Node> invoke(Cache<ServiceName, Set<Node>> cache) {
                HashSet<Node> nodes = new HashSet<Node>(Collections.singleton(node));
                HashSet<Node> existing = (HashSet<Node>)cache.putIfAbsent((Object)service, nodes);
                if (existing != null && existing.add(node)) {
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace((Object)service, existing);
                }
                return existing != null ? existing : nodes;
            }
        };
        this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        return new ServiceProviderRegistrationImpl(service);
    }

    public Set<Node> getServiceProviders(final ServiceName service) {
        Operation<Set<Node>> operation = new Operation<Set<Node>>(){

            public Set<Node> invoke(Cache<ServiceName, Set<Node>> cache) {
                return (Set)cache.get((Object)service);
            }
        };
        Set nodes = (Set)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.emptySet();
    }

    @Override
    public Set<ServiceName> getServices() {
        return this.listeners.keySet();
    }

    public ServiceProviderRegistry getValue() {
        return this;
    }

    public void start(StartContext context) {
        this.dispatcher = ((CommandDispatcherFactory)this.dispatcherFactory.getValue()).createCommandDispatcher(this.name, (Object)this, (MembershipListener)this);
        this.cache = (Cache)this.cacheRef.getValue();
        this.cache.addListener((Object)this);
    }

    public void stop(StopContext context) {
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
    }

    public void membershipChanged(final List<Node> deadNodes, final List<Node> newNodes, List<Node> allNodes, final List<List<Node>> groups) {
        if (((CommandDispatcherFactory)this.dispatcherFactory.getValue()).isCoordinator()) {
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<ServiceName, Set<Node>> cache) {
                    if (!deadNodes.isEmpty()) {
                        for (ServiceName service : cache.keySet()) {
                            Set nodes = (Set)cache.get((Object)service);
                            if (nodes == null || !nodes.removeAll(deadNodes)) continue;
                            cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace((Object)service, (Object)nodes);
                        }
                    }
                    if (groups != null) {
                        for (Node node : newNodes) {
                            List<ServiceName> services = ServiceProviderRegistryFactoryService.this.getServices(node);
                            for (ServiceName service : services) {
                                HashSet<Node> nodes;
                                Set existing = (Set)cache.putIfAbsent((Object)service, nodes = new HashSet<Node>(Collections.singleton(node)));
                                if (existing == null || !existing.add(node)) continue;
                                cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace((Object)service, (Object)existing);
                            }
                        }
                    }
                    return null;
                }
            };
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]);
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<ServiceName, Set<Node>> event) {
        if (event.isPre()) {
            return;
        }
        ServiceProviderRegistration.Listener listener = (ServiceProviderRegistration.Listener)this.listeners.get(event.getKey());
        if (listener != null) {
            listener.serviceProvidersChanged((Set)event.getValue());
        }
    }

    List<ServiceName> getServices(Node node) {
        try {
            return (List)this.dispatcher.executeOnNode((Command)new ServiceProviderCommand(), node).get();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    static interface Operation<R>
    extends CacheInvoker.Operation<ServiceName, Set<Node>, R> {
    }

    private class ServiceProviderRegistrationImpl
    implements ServiceProviderRegistration {
        final ServiceName serviceName;

        ServiceProviderRegistrationImpl(ServiceName serviceName) {
            this.serviceName = serviceName;
        }

        public Set<Node> getServiceProviders() {
            return ServiceProviderRegistryFactoryService.this.getServiceProviders(this.serviceName);
        }

        public void close() {
            if (ServiceProviderRegistryFactoryService.this.listeners.remove(this.serviceName) != null) {
                final Node node = ((CommandDispatcherFactory)ServiceProviderRegistryFactoryService.this.dispatcherFactory.getValue()).getLocalNode();
                Operation<Void> operation = new Operation<Void>(){

                    public Void invoke(Cache<ServiceName, Set<Node>> cache) {
                        Set nodes = (Set)cache.get((Object)ServiceProviderRegistrationImpl.this.serviceName);
                        if (nodes != null && nodes.remove(node)) {
                            if (nodes.isEmpty()) {
                                cache.remove((Object)ServiceProviderRegistrationImpl.this.serviceName);
                            } else {
                                cache.replace((Object)ServiceProviderRegistrationImpl.this.serviceName, (Object)nodes);
                            }
                        }
                        return null;
                    }
                };
                ServiceProviderRegistryFactoryService.this.invoker.invoke(ServiceProviderRegistryFactoryService.this.cache, (CacheInvoker.Operation)operation, new Flag[]{Flag.IGNORE_RETURN_VALUES});
            }
        }
    }
}

