/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.lang.reflect.Method;
import javax.naming.InvalidNameException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.Param;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.StartException;

@MessageBundle(projectCode="JBAS")
public interface SecurityMessages {
    public static final SecurityMessages MESSAGES = (SecurityMessages)Messages.getBundle(SecurityMessages.class);

    @Message(id=13300, value="Unable to get the Module Class Loader")
    public IllegalStateException unableToGetModuleClassLoader(@Cause Throwable var1);

    @Message(id=13301, value="Operation not supported : %s")
    public OperationNotSupportedException operationNotSupported(Method var1);

    @Message(id=13302, value="Missing module name for the %s")
    public IllegalArgumentException missingModuleName(String var1);

    @Message(id=13303, value="Runtime Exception:")
    public RuntimeException runtimeException(@Cause Throwable var1);

    @Message(id=13304, value="Module Load Exception:")
    public ModuleLoadException moduleLoadException(@Cause Throwable var1);

    @Message(id=13305, value="Name cannot be null or empty")
    public InvalidNameException nullName();

    @Message(id=13306, value="Remoting connection found but no UserPrincipal.")
    public LoginException remotingConnectionWithNoUserPrincipal();

    @Message(id=13307, value="Argument %s is null")
    public IllegalArgumentException nullArgument(String var1);

    @Message(id=13308, value="Unable to start the %s service")
    public StartException unableToStartException(String var1, @Cause Throwable var2);

    @Message(id=13309, value="Class not found : %s")
    public ClassNotFoundException cnfe(String var1);

    @Message(id=13310, value="Class not found : %s")
    public ClassNotFoundException cnfeThrow(String var1, @Cause Throwable var2);

    @Message(id=13311, value="Security Exception")
    public SecurityException securityException(@Cause Throwable var1);

    @Message(id=13312, value="Security Exception: %s")
    public SecurityException securityException(String var1);

    @Message(id=13313, value="Vault Reader Exception:")
    public VaultReaderException vaultReaderException(@Cause Throwable var1);

    @Message(id=13314, value="Use the ResourceDescriptionResolver variant")
    public UnsupportedOperationException unsupportedOperationExceptionUseResourceDesc();

    @Message(id=13315, value="Unsupported Operation")
    public UnsupportedOperationException unsupportedOperation();

    @Message(id=13316, value="Illegal Argument:%s")
    public IllegalArgumentException illegalArgument(String var1);

    @Message(id=13317, value="Illegal Argument:%s")
    public XMLStreamException xmlStreamException(String var1, @Param Location var2);

    @Message(id=13318, value="A security domain can have either an <authentication> or <authentication-jaspi> element, not both")
    public XMLStreamException xmlStreamExceptionAuth(@Param Location var1);

    @Message(id=13319, value="Missing required attribute: either %s or %s must be present")
    public XMLStreamException xmlStreamExceptionMissingAttribute(String var1, String var2, @Param Location var3);

    @Message(id=13320, value="auth-module references a login module stack that doesn't exist::%s")
    public IllegalArgumentException loginModuleStackIllegalArgument(String var1);

    @Message(id=13321, value="Address did not contain a security domain name")
    public IllegalArgumentException addressDidNotContainSecurityDomain();

    @Message(id=13322, value="Vault is not initialized")
    public SecurityException vaultNotInitializedException();

    @Message(id=13323, value="Invalid User")
    public SecurityException invalidUserException();

    @Message(id=13324, value="Security Management not injected")
    public SecurityException securityManagementNotInjected();

    @Message(id=13325, value="Security realm '%s' not found.")
    public SecurityException realmNotFound(String var1);

    @Message(id=13326, value="No suitable password validation mechanism identified for realm '%s'")
    public SecurityException noPasswordValidationAvailable(String var1);

    @Message(id=13327, value="Failure calling CallbackHandler '%s'")
    public LoginException failureCallingSecurityRealm(String var1);

    @Message(id=13328, value="No authentication cache for security domain '%s' available")
    public OperationFailedException noAuthenticationCacheAvailable(String var1);

    @Message(id=13329, value="No UserPrincipalFound constructing RemotingConnectionPrincipal.")
    public IllegalStateException noUserPrincipalFound();

    @Message(id=13330, value="Interrupted waiting for security domain '%s'")
    public OperationFailedException interruptedWaitingForSecurityDomain(String var1);

    @Message(id=13331, value="Required security domain is not available '%s'")
    public OperationFailedException requiredSecurityDomainServiceNotAvailable(String var1);
}

