/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import java.util.Collection;
import org.hibernate.criterion.MatchMode;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.internal.tools.Triple;
import org.hibernate.envers.query.criteria.AggregatedAuditExpression;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.BetweenAuditExpression;
import org.hibernate.envers.query.criteria.internal.InAuditExpression;
import org.hibernate.envers.query.criteria.internal.NotNullAuditExpression;
import org.hibernate.envers.query.criteria.internal.NullAuditExpression;
import org.hibernate.envers.query.criteria.internal.PropertyAuditExpression;
import org.hibernate.envers.query.criteria.internal.SimpleAuditExpression;
import org.hibernate.envers.query.internal.property.ModifiedFlagPropertyName;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.order.internal.PropertyAuditOrder;
import org.hibernate.envers.query.projection.AuditProjection;
import org.hibernate.envers.query.projection.internal.PropertyAuditProjection;

public class AuditProperty<T>
implements AuditProjection {
    private final PropertyNameGetter propertyNameGetter;

    public AuditProperty(PropertyNameGetter propertyNameGetter) {
        this.propertyNameGetter = propertyNameGetter;
    }

    public AuditCriterion hasChanged() {
        return new SimpleAuditExpression(new ModifiedFlagPropertyName(this.propertyNameGetter), true, "=");
    }

    public AuditCriterion hasNotChanged() {
        return new SimpleAuditExpression(new ModifiedFlagPropertyName(this.propertyNameGetter), false, "=");
    }

    public AuditCriterion eq(T value) {
        return new SimpleAuditExpression(this.propertyNameGetter, value, "=");
    }

    public AuditCriterion ne(T value) {
        return new SimpleAuditExpression(this.propertyNameGetter, value, "<>");
    }

    public AuditCriterion like(T value) {
        return new SimpleAuditExpression(this.propertyNameGetter, value, " like ");
    }

    public AuditCriterion like(String value, MatchMode matchMode) {
        return new SimpleAuditExpression(this.propertyNameGetter, matchMode.toMatchString(value), " like ");
    }

    public AuditCriterion gt(T value) {
        return new SimpleAuditExpression(this.propertyNameGetter, value, ">");
    }

    public AuditCriterion lt(T value) {
        return new SimpleAuditExpression(this.propertyNameGetter, value, "<");
    }

    public AuditCriterion le(T value) {
        return new SimpleAuditExpression(this.propertyNameGetter, value, "<=");
    }

    public AuditCriterion ge(T value) {
        return new SimpleAuditExpression(this.propertyNameGetter, value, ">=");
    }

    public AuditCriterion between(T lo, T hi) {
        return new BetweenAuditExpression(this.propertyNameGetter, lo, hi);
    }

    public AuditCriterion in(T[] values) {
        return new InAuditExpression(this.propertyNameGetter, values);
    }

    public AuditCriterion in(Collection values) {
        return new InAuditExpression(this.propertyNameGetter, values.toArray());
    }

    public AuditCriterion isNull() {
        return new NullAuditExpression(this.propertyNameGetter);
    }

    public AuditCriterion eqProperty(String otherPropertyName) {
        return new PropertyAuditExpression(this.propertyNameGetter, otherPropertyName, "=");
    }

    public AuditCriterion neProperty(String otherPropertyName) {
        return new PropertyAuditExpression(this.propertyNameGetter, otherPropertyName, "<>");
    }

    public AuditCriterion ltProperty(String otherPropertyName) {
        return new PropertyAuditExpression(this.propertyNameGetter, otherPropertyName, "<");
    }

    public AuditCriterion leProperty(String otherPropertyName) {
        return new PropertyAuditExpression(this.propertyNameGetter, otherPropertyName, "<=");
    }

    public AuditCriterion gtProperty(String otherPropertyName) {
        return new PropertyAuditExpression(this.propertyNameGetter, otherPropertyName, ">");
    }

    public AuditCriterion geProperty(String otherPropertyName) {
        return new PropertyAuditExpression(this.propertyNameGetter, otherPropertyName, ">=");
    }

    public AuditCriterion isNotNull() {
        return new NotNullAuditExpression(this.propertyNameGetter);
    }

    public AggregatedAuditExpression maximize() {
        return new AggregatedAuditExpression(this.propertyNameGetter, AggregatedAuditExpression.AggregatedMode.MAX);
    }

    public AggregatedAuditExpression minimize() {
        return new AggregatedAuditExpression(this.propertyNameGetter, AggregatedAuditExpression.AggregatedMode.MIN);
    }

    public AuditProjection max() {
        return new PropertyAuditProjection(this.propertyNameGetter, "max", false);
    }

    public AuditProjection min() {
        return new PropertyAuditProjection(this.propertyNameGetter, "min", false);
    }

    public AuditProjection count() {
        return new PropertyAuditProjection(this.propertyNameGetter, "count", false);
    }

    public AuditProjection countDistinct() {
        return new PropertyAuditProjection(this.propertyNameGetter, "count", true);
    }

    public AuditProjection distinct() {
        return new PropertyAuditProjection(this.propertyNameGetter, null, true);
    }

    public AuditProjection function(String functionName) {
        return new PropertyAuditProjection(this.propertyNameGetter, functionName, false);
    }

    @Override
    public Triple<String, String, Boolean> getData(AuditConfiguration auditCfg) {
        return Triple.make(null, this.propertyNameGetter.get(auditCfg), false);
    }

    public AuditOrder asc() {
        return new PropertyAuditOrder(this.propertyNameGetter, true);
    }

    public AuditOrder desc() {
        return new PropertyAuditOrder(this.propertyNameGetter, false);
    }
}

