/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.remoting.EndpointConfigFactory;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

class RemotingSubsystemAdd
extends AbstractAddStepHandler {
    static final RemotingSubsystemAdd DOMAIN = new RemotingSubsystemAdd(false);
    static final RemotingSubsystemAdd SERVER = new RemotingSubsystemAdd(true);
    private final boolean server;

    private RemotingSubsystemAdd(boolean server) {
        this.server = server;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : RemotingSubsystemRootResource.ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return this.server;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        this.launchServices(context, model, verificationHandler, newControllers);
    }

    void launchServices(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceController controller;
        ServiceTarget serviceTarget = context.getServiceTarget();
        String nodeName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
        EndpointService endpointService = new EndpointService(nodeName, EndpointService.EndpointType.SUBSYSTEM);
        OptionMap map = EndpointConfigFactory.create((ExpressionResolver)context, model);
        endpointService.setOptionMap(map);
        if (context.getProcessType() == ProcessType.DOMAIN_SERVER && (controller = context.getServiceRegistry(false).getService(RemotingServices.SUBSYSTEM_ENDPOINT)) != null) {
            return;
        }
        ServiceBuilder builder = serviceTarget.addService(RemotingServices.SUBSYSTEM_ENDPOINT, (Service)endpointService);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller2 = builder.install();
        if (newControllers != null) {
            newControllers.add(controller2);
        }
    }
}

