/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.ComponentFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

class ComponentInstantiatorInterceptorFactory
implements InterceptorFactory {
    private final ComponentFactory componentInstantiation;
    private final Object contextKey;
    private final boolean setTarget;

    public ComponentInstantiatorInterceptorFactory(ComponentFactory componentInstantiation, Object contextKey, boolean setTarget) {
        this.setTarget = setTarget;
        if (componentInstantiation == null) {
            throw EeMessages.MESSAGES.nullVar("componentInstantiation");
        }
        if (contextKey == null) {
            throw EeMessages.MESSAGES.nullVar("contextKey");
        }
        this.componentInstantiation = componentInstantiation;
        this.contextKey = contextKey;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        AtomicReference<ManagedReference> referenceReference = (AtomicReference<ManagedReference>)context.getContextData().get(this.contextKey);
        if (referenceReference == null) {
            referenceReference = new AtomicReference<ManagedReference>();
            context.getContextData().put(this.contextKey, referenceReference);
        }
        return new ManagedReferenceInterceptor(this.componentInstantiation, referenceReference, this.setTarget);
    }

    static final class ManagedReferenceInterceptor
    implements Interceptor {
        private final ComponentFactory componentFactory;
        private final AtomicReference<ManagedReference> referenceReference;
        private final boolean setTarget;

        public ManagedReferenceInterceptor(ComponentFactory componentFactory, AtomicReference<ManagedReference> referenceReference, boolean setTarget) {
            this.componentFactory = componentFactory;
            this.referenceReference = referenceReference;
            this.setTarget = setTarget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            ManagedReference existing = this.referenceReference.get();
            if (existing == null) {
                ManagedReference reference = this.componentFactory.create(context);
                boolean ok = false;
                try {
                    this.referenceReference.set(reference);
                    if (this.setTarget) {
                        context.setTarget(reference.getInstance());
                    }
                    Object result = context.proceed();
                    ok = true;
                    Object object = result;
                    return object;
                }
                finally {
                    if (!ok) {
                        reference.release();
                        this.referenceReference.set(null);
                    }
                }
            }
            return context.proceed();
        }
    }
}

