/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

class ManagedReferenceReleaseInterceptorFactory
implements InterceptorFactory {
    private final Object contextKey;

    public ManagedReferenceReleaseInterceptorFactory(Object contextKey) {
        if (contextKey == null) {
            throw EeMessages.MESSAGES.nullVar("contextKey");
        }
        this.contextKey = contextKey;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        AtomicReference referenceReference = (AtomicReference)context.getContextData().get(this.contextKey);
        return new ManagedReferenceReleaseInterceptor(referenceReference);
    }

    static final class ManagedReferenceReleaseInterceptor
    implements Interceptor {
        private final AtomicReference<ManagedReference> referenceReference;

        public ManagedReferenceReleaseInterceptor(AtomicReference<ManagedReference> referenceReference) {
            if (referenceReference == null) {
                throw EeMessages.MESSAGES.nullVar("referenceReference");
            }
            this.referenceReference = referenceReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            try {
                Object object = context.proceed();
                return object;
            }
            finally {
                ManagedReference managedReference = this.referenceReference.getAndSet(null);
                if (managedReference != null) {
                    managedReference.release();
                }
            }
        }
    }
}

