/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.interceptor.CdiInterceptorFactory;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Formats;

public class InterceptorImpl<T>
extends ManagedBean<T>
implements Interceptor<T> {
    private final InterceptorMetadata<T> interceptorMetadata;
    private final Set<Annotation> interceptorBindingTypes;
    private final boolean serializable;

    public static <T> InterceptorImpl<T> of(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        return new InterceptorImpl<T>(attributes, type, beanManager);
    }

    protected InterceptorImpl(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        super(attributes, type, Interceptor.class.getSimpleName() + "-" + type.getName(), beanManager);
        this.interceptorMetadata = InterceptorImpl.getInterceptorMetadata(type, this, beanManager);
        this.serializable = type.isSerializable();
        this.interceptorBindingTypes = Collections.unmodifiableSet(new HashSet<Annotation>(Interceptors.mergeBeanInterceptorBindings(beanManager, this.getEnhancedAnnotated(), this.getStereotypes()).values()));
        if (this.interceptorBindingTypes.size() == 0) {
            throw new DeploymentException(BeanMessage.MISSING_BINDING_ON_INTERCEPTOR, type.getName());
        }
        if (Beans.findInterceptorBindingConflicts(beanManager, this.interceptorBindingTypes)) {
            throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType());
        }
    }

    private static <T> InterceptorMetadata<T> getInterceptorMetadata(EnhancedAnnotatedType<T> type, Interceptor<T> interceptor, BeanManagerImpl manager) {
        WeldInterceptorClassMetadata<T> classMetadata = WeldInterceptorClassMetadata.of(type);
        CdiInterceptorFactory<T> reference = new CdiInterceptorFactory<T>(classMetadata, interceptor);
        return manager.getInterceptorMetadataReader().getInterceptorMetadata(reference);
    }

    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindingTypes;
    }

    public InterceptorMetadata<T> getInterceptorMetadata() {
        return this.interceptorMetadata;
    }

    public Object intercept(javax.enterprise.inject.spi.InterceptionType type, T instance, InvocationContext ctx) {
        try {
            InterceptionType interceptionType = InterceptionType.valueOf(type.name());
            ArrayList<InterceptorInvocation> invocations = new ArrayList<InterceptorInvocation>();
            invocations.add(this.interceptorMetadata.getInterceptorInvocation(instance, interceptionType));
            return new SimpleInterceptionChain(invocations).invokeNextInterceptor(ctx);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WeldException(e);
        }
    }

    public boolean intercepts(javax.enterprise.inject.spi.InterceptionType type) {
        return this.interceptorMetadata.isEligible(InterceptionType.valueOf(type.name()));
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        this.checkInterceptorBindings();
    }

    private void checkInterceptorBindings() {
        if (this.interceptorMetadata.isEligible(InterceptionType.POST_CONSTRUCT) || this.interceptorMetadata.isEligible(InterceptionType.PRE_DESTROY) || this.interceptorMetadata.isEligible(InterceptionType.POST_ACTIVATE) || this.interceptorMetadata.isEligible(InterceptionType.PRE_PASSIVATE)) {
            for (Annotation interceptorBindingType : this.interceptorBindingTypes) {
                Target target = interceptorBindingType.annotationType().getAnnotation(Target.class);
                if (target == null || !Arrays2.unorderedEquals((Object[])target.value(), new Object[]{ElementType.TYPE, ElementType.METHOD})) continue;
                throw new DefinitionException(ReflectionMessage.METHOD_ELEMENT_TYPE_NOT_ALLOWED, this, interceptorBindingType.annotationType());
            }
        }
    }

    @Override
    public String toString() {
        return "Interceptor [" + this.getBeanClass() + " intercepts " + Formats.formatAnnotations(this.getInterceptorBindings()) + "]";
    }
}

