/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.wildfly.extension.rts.RTSSubsystemDefinition;
import org.wildfly.extension.rts.RTSSubsystemExtension;
import org.wildfly.extension.rts.configuration.Attribute;
import org.wildfly.extension.rts.logging.RTSLogger;
import org.wildfly.extension.rts.service.CoordinatorService;
import org.wildfly.extension.rts.service.ParticipantService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

final class RTSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final RTSSubsystemAdd INSTANCE = new RTSSubsystemAdd();

    private RTSSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (RTSLogger.ROOT_LOGGER.isTraceEnabled()) {
            RTSLogger.ROOT_LOGGER.trace("RTSSubsystemAdd.populateModel");
        }
        RTSSubsystemDefinition.SERVER.validateAndSet(operation, model);
        RTSSubsystemDefinition.HOST.validateAndSet(operation, model);
        RTSSubsystemDefinition.SOCKET_BINDING.validateAndSet(operation, model);
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        if (RTSLogger.ROOT_LOGGER.isTraceEnabled()) {
            RTSLogger.ROOT_LOGGER.trace("RTSSubsystemAdd.performBoottime");
        }
        String serverName = model.get(Attribute.SERVER.getLocalName()).asString();
        String hostName = model.get(Attribute.HOST.getLocalName()).asString();
        String socketBindingName = model.get(Attribute.SOCKET_BINDING.getLocalName()).asString();
        CoordinatorService coordinatorService = new CoordinatorService();
        ParticipantService participantService = new ParticipantService();
        ServiceBuilder coordinatorServiceBuilder = context.getServiceTarget().addService(RTSSubsystemExtension.COORDINATOR, (Service)coordinatorService).addListener((ServiceListener)verificationHandler).addDependency(UndertowService.virtualHostName((String)serverName, (String)hostName), Host.class, coordinatorService.getInjectedHost());
        ServiceBuilder participantServiceBuilder = context.getServiceTarget().addService(RTSSubsystemExtension.PARTICIPANT, (Service)participantService).addListener((ServiceListener)verificationHandler).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName}), SocketBinding.class, participantService.getInjectedSocketBinding()).addDependency(UndertowService.virtualHostName((String)serverName, (String)hostName), Host.class, participantService.getInjectedHost());
        coordinatorServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        participantServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController coordinatorServiceController = coordinatorServiceBuilder.install();
        ServiceController participantServiceController = participantServiceBuilder.install();
        if (newControllers != null) {
            newControllers.add(coordinatorServiceController);
            newControllers.add(participantServiceController);
        }
    }
}

