/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.Dictionary;
import java.util.Hashtable;
import org.jboss.as.configadmin.parser.ConfigAdminExtension;
import org.jboss.as.configadmin.service.ConfigAdminInternal;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ConfigurationUpdate
implements OperationStepHandler {
    static final ConfigurationUpdate INSTANCE = new ConfigurationUpdate();

    private ConfigurationUpdate() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        resource.getModel().get("entries").set(operation.get("entries"));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode entries = operation.get("entries");
                String pid = operation.get("address").asObject().get("configuration").asString();
                Hashtable<String, String> dictionary = new Hashtable<String, String>();
                for (String key : entries.keys()) {
                    ((Dictionary)dictionary).put(key, entries.get(key).asString());
                }
                ConfigAdminInternal configAdmin = ConfigAdminExtension.getConfigAdminService(context);
                if (configAdmin != null) {
                    configAdmin.putConfigurationInternal(pid, dictionary);
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

