/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.txframework.impl.handlers.wsat;

import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.Volatile2PCParticipant;
import com.arjuna.wst.WrongStateException;
import java.util.HashMap;
import java.util.UUID;
import org.jboss.narayana.txframework.api.exception.TXFrameworkException;
import org.jboss.narayana.txframework.impl.Participant;
import org.jboss.narayana.txframework.impl.ServiceInvocationMeta;
import org.jboss.narayana.txframework.impl.handlers.ParticipantRegistrationException;
import org.jboss.narayana.txframework.impl.handlers.ProtocolHandler;
import org.jboss.narayana.txframework.impl.handlers.wsat.WSATDurable2PCParticipant;
import org.jboss.narayana.txframework.impl.handlers.wsat.WSATVolatile2PCParticipant;

public class WSATHandler
implements ProtocolHandler {
    private Durable2PCParticipant durableParticipant;

    public WSATHandler(ServiceInvocationMeta serviceInvocationMeta) throws TXFrameworkException {
        try {
            HashMap txDataMap = new HashMap();
            WSATVolatile2PCParticipant volatileParticipant = new WSATVolatile2PCParticipant(serviceInvocationMeta, txDataMap);
            this.durableParticipant = new WSATDurable2PCParticipant(serviceInvocationMeta, txDataMap);
            TransactionManager transactionManager = TransactionManagerFactory.transactionManager();
            String idPrefix = serviceInvocationMeta.getServiceClass().getName();
            transactionManager.enlistForVolatileTwoPhase((Volatile2PCParticipant)volatileParticipant, idPrefix + UUID.randomUUID());
            transactionManager.enlistForDurableTwoPhase(this.durableParticipant, idPrefix + UUID.randomUUID());
        }
        catch (WrongStateException e) {
            throw new ParticipantRegistrationException("Transaction was not in a state in which participants can be registered", e);
        }
        catch (UnknownTransactionException e) {
            throw new ParticipantRegistrationException("Can't register a participant as the transaction in unknown", e);
        }
        catch (SystemException e) {
            throw new ParticipantRegistrationException("A SystemException occurred when attempting to register a participant", e);
        }
    }

    @Override
    public void preInvocation() throws Exception {
        ((Participant)this.durableParticipant).resume();
    }

    @Override
    public void notifySuccess() {
        Participant.suspend();
    }

    @Override
    public void notifyFailure() {
        Participant.suspend();
    }
}

