/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.EventInvoker;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowService;

public class Host
implements Service<Host>,
WebHost {
    private final PathHandler pathHandler = new PathHandler();
    private final Set<String> allAliases;
    private final String name;
    private final InjectedValue<Server> server = new InjectedValue();
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private final Set<Deployment> deployments = new CopyOnWriteArraySet<Deployment>();

    protected Host(String name, List<String> aliases) {
        this.name = name;
        HashSet<String> hosts = new HashSet<String>(aliases.size() + 1);
        hosts.add(name);
        hosts.addAll(aliases);
        this.allAliases = Collections.unmodifiableSet(hosts);
    }

    public void start(StartContext context) throws StartException {
        ((Server)this.server.getValue()).registerHost(this);
        UndertowLogger.ROOT_LOGGER.infof("Starting host %s", this.name);
    }

    public void stop(StopContext context) {
        ((Server)this.server.getValue()).unregisterHost(this);
        this.pathHandler.clearPaths();
        UndertowLogger.ROOT_LOGGER.infof("Stopping host %s", this.name);
    }

    public Host getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected InjectedValue<Server> getServerInjection() {
        return this.server;
    }

    public Server getServer() {
        return (Server)this.server.getValue();
    }

    protected InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public Set<String> getAllAliases() {
        return this.allAliases;
    }

    public String getName() {
        return this.name;
    }

    protected HttpHandler getRootHandler() {
        return this.pathHandler;
    }

    public void registerDeployment(final Deployment deployment, HttpHandler handler) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = ServletContainerService.getDeployedContextPath(deploymentInfo);
        this.registerHandler(path, handler);
        this.deployments.add(deployment);
        UndertowLogger.ROOT_LOGGER.registerWebapp(path);
        ((UndertowService)this.undertowService.getValue()).fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onDeploymentStart(deployment, Host.this);
            }
        });
    }

    public void unregisterDeployment(final Deployment deployment) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = ServletContainerService.getDeployedContextPath(deploymentInfo);
        this.unregisterHandler(path);
        this.deployments.remove(deployment);
        UndertowLogger.ROOT_LOGGER.unregisterWebapp(path);
        ((UndertowService)this.undertowService.getValue()).fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onDeploymentStop(deployment, Host.this);
            }
        });
    }

    public void registerHandler(String path, HttpHandler handler) {
        this.pathHandler.addPath(path, handler);
    }

    public void unregisterHandler(String path) {
        this.pathHandler.removePath(path);
    }

    public Set<String> getContexts() {
        return this.pathHandler.getPaths().keySet();
    }

    public Set<Deployment> getDeployments() {
        return Collections.unmodifiableSet(this.deployments);
    }

    public WebDeploymentController addWebDeployment(WebDeploymentBuilder webDeploymentBuilder) throws Exception {
        DeploymentInfo d = new DeploymentInfo();
        d.setDeploymentName(webDeploymentBuilder.getContextRoot());
        d.setContextPath(webDeploymentBuilder.getContextRoot());
        d.setClassLoader(webDeploymentBuilder.getClassLoader());
        d.setResourceManager((ResourceManager)new FileResourceManager(new File(webDeploymentBuilder.getDocumentRoot().getAbsolutePath())));
        for (ServletBuilder servlet : webDeploymentBuilder.getServlets()) {
            ServletInfo s = servlet.getServlet() == null ? new ServletInfo(servlet.getServletName(), servlet.getServletClass()) : new ServletInfo(servlet.getServletName(), servlet.getServletClass(), (InstanceFactory)new ImmediateInstanceFactory((Object)servlet.getServlet()));
            if (servlet.isForceInit()) {
                s.setLoadOnStartup(Integer.valueOf(1));
            }
            s.addMappings((Collection)servlet.getUrlMappings());
            for (Map.Entry param : servlet.getInitParams().entrySet()) {
                s.addInitParam((String)param.getKey(), (String)param.getValue());
            }
            d.addServlet(s);
        }
        return new WebDeploymentControllerImpl(d);
    }

    private class WebDeploymentControllerImpl
    implements WebDeploymentController {
        private final DeploymentInfo deploymentInfo;
        private volatile DeploymentManager manager;

        private WebDeploymentControllerImpl(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        public void create() throws Exception {
            ServletContainer container = ((ServletContainerService)((Server)Host.this.getServerInjection().getValue()).getServletContainer().getValue()).getServletContainer();
            this.manager = container.addDeployment(this.deploymentInfo);
            this.manager.deploy();
        }

        public void start() throws Exception {
            HttpHandler handler = this.manager.start();
            Host.this.registerDeployment(this.manager.getDeployment(), handler);
        }

        public void stop() throws Exception {
            Host.this.unregisterDeployment(this.manager.getDeployment());
            this.manager.stop();
        }

        public void destroy() throws Exception {
            this.manager.undeploy();
            ServletContainer container = ((ServletContainerService)((Server)Host.this.getServerInjection().getValue()).getServletContainer().getValue()).getServletContainer();
            container.removeDeployment(this.deploymentInfo);
        }
    }
}

