/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.AbstractListenerAdd;
import org.wildfly.extension.undertow.AbstractListenerService;
import org.wildfly.extension.undertow.HttpListenerAdd;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerService;
import org.wildfly.extension.undertow.UndertowService;

public class HttpsListenerAdd
extends AbstractListenerAdd {
    HttpsListenerAdd(HttpsListenerResourceDefinition def) {
        super(def);
    }

    @Override
    protected ServiceName constructServiceName(String name) {
        return UndertowService.LISTENER.append(new String[]{name});
    }

    @Override
    AbstractListenerService<? extends AbstractListenerService> createService(String name, String serverName, OperationContext context, ModelNode model, long maxUploadSize) throws OperationFailedException {
        return new HttpsListenerService(name, serverName, maxUploadSize);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, ServiceBuilder<? extends AbstractListenerService> serviceBuilder, ModelNode model, AbstractListenerService service) throws OperationFailedException {
        serviceBuilder.addDependency(HttpListenerAdd.REGISTRY_SERVICE_NAME, ListenerRegistry.class, ((HttpListenerService)service).getHttpListenerRegistry());
        String securityRealm = HttpsListenerResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model).asString();
        serviceBuilder.addDependency(SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}), SecurityRealm.class, ((HttpsListenerService)service).getSecurityRealm());
    }
}

