/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.ServletStackTraces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.JspDefinition;
import org.wildfly.extension.undertow.PersistentSessionsDefinition;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.SessionCookieDefinition;
import org.wildfly.extension.undertow.UndertowExtension;

public class ServletContainerDefinition
extends PersistentResourceDefinition {
    static final ServletContainerDefinition INSTANCE = new ServletContainerDefinition();
    protected static final SimpleAttributeDefinition ALLOW_NON_STANDARD_WRAPPERS = new SimpleAttributeDefinitionBuilder("allow-non-standard-wrappers", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition DEFAULT_BUFFER_CACHE = new SimpleAttributeDefinitionBuilder("default-buffer-cache", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    protected static final SimpleAttributeDefinition STACK_TRACE_ON_ERROR = new SimpleAttributeDefinitionBuilder("stack-trace-on-error", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode("none")).setValidator((ParameterValidator)new EnumValidator(ServletStackTraces.class, true, true)).setAllowExpression(true).build();
    private static final List<? extends PersistentResourceDefinition> CHILDREN;

    private ServletContainerDefinition() {
        super(UndertowExtension.PATH_SERVLET_CONTAINER, (ResourceDescriptionResolver)UndertowExtension.getResolver("servlet-container"), (OperationStepHandler)ServletContainerAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        attributes.add((AttributeDefinition)ALLOW_NON_STANDARD_WRAPPERS);
        attributes.add((AttributeDefinition)DEFAULT_BUFFER_CACHE);
        attributes.add((AttributeDefinition)STACK_TRACE_ON_ERROR);
        return attributes;
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return CHILDREN;
    }

    static {
        ArrayList<PersistentResourceDefinition> children = new ArrayList<PersistentResourceDefinition>();
        children.add(JspDefinition.INSTANCE);
        children.add(SessionCookieDefinition.INSTANCE);
        children.add(PersistentSessionsDefinition.INSTANCE);
        CHILDREN = Collections.unmodifiableList(children);
    }
}

