/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jboss.as.web.common.StartupContext;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.host.ContextActivator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowMessages;

public class UndertowDeploymentService
implements Service<UndertowDeploymentService> {
    private final InjectedValue<ServletContainerService> container = new InjectedValue();
    private final WebInjectionContainer webInjectionContainer;
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<DeploymentInfo> deploymentInfoInjectedValue = new InjectedValue();
    private final boolean autostart;
    private volatile DeploymentManager deploymentManager;

    public UndertowDeploymentService(WebInjectionContainer webInjectionContainer, boolean autostart) {
        this.webInjectionContainer = webInjectionContainer;
        this.autostart = autostart;
    }

    public void start(StartContext startContext) throws StartException {
        if (this.autostart) {
            try {
                this.startContext();
            }
            catch (ServletException e) {
                throw new StartException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContext() throws ServletException {
        DeploymentInfo deploymentInfo = (DeploymentInfo)this.deploymentInfoInjectedValue.getValue();
        StartupContext.setInjectionContainer((WebInjectionContainer)this.webInjectionContainer);
        try {
            this.deploymentManager = ((ServletContainerService)this.container.getValue()).getServletContainer().addDeployment(deploymentInfo);
            this.deploymentManager.deploy();
            HttpHandler handler = this.deploymentManager.start();
            Deployment deployment = this.deploymentManager.getDeployment();
            ((Host)this.host.getValue()).registerDeployment(deployment, handler);
        }
        finally {
            StartupContext.setInjectionContainer(null);
        }
    }

    public void stop(StopContext stopContext) {
        this.stopContext();
    }

    public void stopContext() {
        if (this.deploymentManager != null) {
            Deployment deployment = this.deploymentManager.getDeployment();
            try {
                ((Host)this.host.getValue()).unregisterDeployment(deployment);
                this.deploymentManager.stop();
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            this.deploymentManager.undeploy();
            ((ServletContainerService)this.container.getValue()).getServletContainer().removeDeployment((DeploymentInfo)this.deploymentInfoInjectedValue.getValue());
        }
        UndertowDeploymentService.recursiveDelete(((DeploymentInfo)this.deploymentInfoInjectedValue.getValue()).getTempDir());
    }

    public UndertowDeploymentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ServletContainerService> getContainer() {
        return this.container;
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }

    public InjectedValue<DeploymentInfo> getDeploymentInfoInjectedValue() {
        return this.deploymentInfoInjectedValue;
    }

    private static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            UndertowDeploymentService.recursiveDelete(f);
        }
        if (!file.delete()) {
            UndertowLogger.ROOT_LOGGER.couldNotDeleteTempFile(file);
        }
    }

    protected static class ContextActivatorImpl
    implements ContextActivator {
        private final ServiceController<UndertowDeploymentService> controller;

        ContextActivatorImpl(ServiceController<UndertowDeploymentService> controller) {
            this.controller = controller;
        }

        public synchronized boolean startContext() {
            try {
                UndertowDeploymentService service = (UndertowDeploymentService)this.controller.getValue();
                service.startContext();
            }
            catch (Exception ex) {
                throw UndertowMessages.MESSAGES.cannotActivateContext(ex, this.controller.getName());
            }
            return true;
        }

        public synchronized boolean stopContext() {
            UndertowDeploymentService service = (UndertowDeploymentService)this.controller.getValue();
            service.stopContext();
            return true;
        }

        public ServletContext getServletContext() {
            UndertowDeploymentService service = (UndertowDeploymentService)this.controller.getValue();
            DeploymentManager manager = service.deploymentManager;
            Deployment deployment = manager != null ? manager.getDeployment() : null;
            return deployment != null ? deployment.getServletContext() : null;
        }
    }
}

