/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.jboss.security.SecurityContext;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;

public class SecurityContextCreationHandler
implements HttpHandler {
    private final String securityDomain;
    private final HttpHandler next;

    public SecurityContextCreationHandler(String securityDomain, HttpHandler next) {
        this.securityDomain = securityDomain;
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        try {
            SecurityContext sc = SecurityActions.createSecurityContext(this.securityDomain);
            exchange.putAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT, (Object)sc);
            SecurityActions.setSecurityContextOnAssociation(sc);
            this.next.handleRequest(exchange);
        }
        finally {
            SecurityActions.clearSecurityContext();
        }
    }

    public static final HandlerWrapper wrapper(final String securityDomain) {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new SecurityContextCreationHandler(securityDomain, handler);
            }
        };
    }
}

