/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.dialect.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseInfoDialectResolver;

public class DatabaseInfoDialectResolverSet
implements DatabaseInfoDialectResolver {
    private List<DatabaseInfoDialectResolver> delegateResolvers;

    public DatabaseInfoDialectResolverSet() {
        this(new ArrayList<DatabaseInfoDialectResolver>());
    }

    public DatabaseInfoDialectResolverSet(List<DatabaseInfoDialectResolver> delegateResolvers) {
        this.delegateResolvers = delegateResolvers;
    }

    public DatabaseInfoDialectResolverSet(DatabaseInfoDialectResolver ... delegateResolvers) {
        this(Arrays.asList(delegateResolvers));
    }

    @Override
    public Dialect resolve(DatabaseInfoDialectResolver.DatabaseInfo databaseInfo) {
        for (DatabaseInfoDialectResolver resolver : this.delegateResolvers) {
            Dialect dialect = resolver.resolve(databaseInfo);
            if (dialect == null) continue;
            return dialect;
        }
        return null;
    }

    public void addResolver(DatabaseInfoDialectResolver resolver) {
        this.delegateResolvers.add(resolver);
    }

    public void addResolverAtFirst(DatabaseInfoDialectResolver resolver) {
        this.delegateResolvers.add(0, resolver);
    }
}

