/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.lang.instrument.ClassFileTransformer;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.AliasModuleSpec;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModulesPolicy;
import org.jboss.modules.ResourceLoaderSpec;

public abstract class ModuleSpec {
    private final ModuleIdentifier moduleIdentifier;

    ModuleSpec(ModuleIdentifier moduleIdentifier) {
        this.moduleIdentifier = moduleIdentifier;
    }

    public static Builder build(final ModuleIdentifier moduleIdentifier) {
        if (moduleIdentifier == null) {
            throw new IllegalArgumentException("moduleIdentifier is null");
        }
        return new Builder(){
            private String mainClass;
            private AssertionSetting assertionSetting = AssertionSetting.INHERIT;
            private final List<ResourceLoaderSpec> resourceLoaders = new ArrayList<ResourceLoaderSpec>(0);
            private final List<DependencySpec> dependencies = new ArrayList<DependencySpec>();
            private final Map<String, String> properties = new LinkedHashMap<String, String>(0);
            private LocalLoader fallbackLoader;
            private ModuleClassLoaderFactory moduleClassLoaderFactory;
            private ClassFileTransformer classFileTransformer;
            private PermissionCollection permissionCollection = ModulesPolicy.DEFAULT_PERMISSION_COLLECTION;

            @Override
            public Builder setFallbackLoader(LocalLoader fallbackLoader) {
                this.fallbackLoader = fallbackLoader;
                return this;
            }

            @Override
            public Builder setMainClass(String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            @Override
            public Builder setAssertionSetting(AssertionSetting assertionSetting) {
                this.assertionSetting = assertionSetting == null ? AssertionSetting.INHERIT : assertionSetting;
                return this;
            }

            @Override
            public Builder addDependency(DependencySpec dependencySpec) {
                this.dependencies.add(dependencySpec);
                return this;
            }

            @Override
            public Builder addResourceRoot(ResourceLoaderSpec resourceLoader) {
                this.resourceLoaders.add(resourceLoader);
                return this;
            }

            @Override
            public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory moduleClassLoaderFactory) {
                this.moduleClassLoaderFactory = moduleClassLoaderFactory;
                return this;
            }

            @Override
            public Builder setClassFileTransformer(ClassFileTransformer classFileTransformer) {
                this.classFileTransformer = classFileTransformer;
                return this;
            }

            @Override
            public Builder addProperty(String name, String value) {
                this.properties.put(name, value);
                return this;
            }

            @Override
            public Builder setPermissionCollection(PermissionCollection permissionCollection) {
                this.permissionCollection = permissionCollection == null ? ModulesPolicy.DEFAULT_PERMISSION_COLLECTION : permissionCollection;
                return this;
            }

            @Override
            public ModuleSpec create() {
                return new ConcreteModuleSpec(moduleIdentifier, this.mainClass, this.assertionSetting, this.resourceLoaders.toArray(new ResourceLoaderSpec[this.resourceLoaders.size()]), this.dependencies.toArray(new DependencySpec[this.dependencies.size()]), this.fallbackLoader, this.moduleClassLoaderFactory, this.classFileTransformer, this.properties, this.permissionCollection);
            }

            @Override
            public ModuleIdentifier getIdentifier() {
                return moduleIdentifier;
            }
        };
    }

    public static AliasBuilder buildAlias(final ModuleIdentifier moduleIdentifier, final ModuleIdentifier aliasTarget) {
        if (moduleIdentifier == null) {
            throw new IllegalArgumentException("moduleIdentifier is null");
        }
        if (aliasTarget == null) {
            throw new IllegalArgumentException("aliasTarget is null");
        }
        return new AliasBuilder(){

            @Override
            public ModuleSpec create() {
                return new AliasModuleSpec(moduleIdentifier, aliasTarget);
            }

            @Override
            public ModuleIdentifier getIdentifier() {
                return moduleIdentifier;
            }

            @Override
            public ModuleIdentifier getAliasTarget() {
                return aliasTarget;
            }
        };
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public static interface AliasBuilder {
        public ModuleSpec create();

        public ModuleIdentifier getIdentifier();

        public ModuleIdentifier getAliasTarget();
    }

    public static interface Builder {
        public Builder setMainClass(String var1);

        public Builder setAssertionSetting(AssertionSetting var1);

        public Builder addDependency(DependencySpec var1);

        public Builder addResourceRoot(ResourceLoaderSpec var1);

        public ModuleSpec create();

        public ModuleIdentifier getIdentifier();

        public Builder setFallbackLoader(LocalLoader var1);

        public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory var1);

        public Builder setClassFileTransformer(ClassFileTransformer var1);

        public Builder addProperty(String var1, String var2);

        public Builder setPermissionCollection(PermissionCollection var1);
    }
}

