/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.audit;

import java.io.InputStream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.audit.SecurityActions;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PicketLinkAuditHelper {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private AuditManager auditManager = null;

    public PicketLinkAuditHelper(String securityDomainName) throws ConfigurationException {
        try {
            InitialContext context = new InitialContext();
            this.auditManager = (AuditManager)context.lookup("java:jboss/jaas/" + securityDomainName + "/auditMgr");
        }
        catch (NamingException e) {
            throw logger.auditAuditManagerNotFound("java:jboss/jaas/" + securityDomainName + "/auditMgr", e);
        }
    }

    public void audit(AuditEvent ae) {
        if (this.auditManager == null) {
            throw logger.auditNullAuditManager();
        }
        this.auditManager.audit(ae);
    }

    public static String getSecurityDomainName(ServletContext servletContext) throws ConfigurationException {
        try {
            InitialContext context = new InitialContext();
            Object theDomain = context.lookup("java:comp/env/security/security-domain");
            return (String)theDomain;
        }
        catch (NamingException e) {
            InputStream is = servletContext.getResourceAsStream("/WEB-INF/jboss-web.xml");
            if (is != null) {
                try {
                    Document dom = DocumentUtil.getDocument(is);
                    return PicketLinkAuditHelper.getSecurityDomainNameViaDom(dom);
                }
                catch (Exception e1) {
                    throw logger.auditSecurityDomainNotFound(e1);
                }
            }
            String secDomain = SecurityActions.getSystemProperty("picketlink.audit.securitydomain", null);
            if (StringUtil.isNotNull(secDomain)) {
                return secDomain;
            }
            throw logger.auditSecurityDomainNotFound(e);
        }
    }

    private static String getSecurityDomainNameViaDom(Document doc) {
        Element rootNode = doc.getDocumentElement();
        NodeList nl = rootNode.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Element el;
            Node child = nl.item(i);
            if (!(child instanceof Element) || !"security-domain".equals((el = (Element)child).getNodeName())) continue;
            NodeList nl1 = el.getChildNodes();
            int len = nl1.getLength();
            for (int j = 0; j < len; ++j) {
                Node aChild = nl1.item(j);
                if (!(aChild instanceof Text)) continue;
                return ((Text)aChild).getNodeValue();
            }
        }
        return null;
    }
}

