/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetSocketAddress;
import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerService;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

public class ModClusterGetProxyConfiguration
implements OperationStepHandler {
    static final ModClusterGetProxyConfiguration INSTANCE = new ModClusterGetProxyConfiguration();

    static OperationDefinition getDefinition(ResourceDescriptionResolver descriptionResolver) {
        return new SimpleOperationDefinitionBuilder("read-proxies-configuration", descriptionResolver).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF).build();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ContainerEventHandlerService.SERVICE_NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ContainerEventHandlerService.SERVICE_NAME);
                    ModClusterServiceMBean service = (ModClusterServiceMBean)controller.getValue();
                    Map map = service.getProxyConfiguration();
                    ModClusterLogger.ROOT_LOGGER.debugf("Mod_cluster ProxyConfiguration %s", map);
                    if (!map.isEmpty()) {
                        InetSocketAddress[] addr;
                        ModelNode result = new ModelNode();
                        for (InetSocketAddress address : addr = map.keySet().toArray(new InetSocketAddress[map.size()])) {
                            result.add(address.getHostName() + ":" + address.getPort());
                            result.add((String)map.get(address));
                        }
                        context.getResult().set(result);
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

