/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.hornetq.api.core.SimpleString;
import org.hornetq.jms.client.HornetQJMSContext;
import org.hornetq.jms.client.JmsExceptionUtils;
import org.hornetq.jms.client.ThreadAwareContext;
import org.hornetq.utils.TypedProperties;

public final class HornetQJMSProducer
implements JMSProducer {
    private final HornetQJMSContext context;
    private final MessageProducer producer;
    private final TypedProperties properties = new TypedProperties();
    private volatile CompletionListener completionListener;
    private Destination jmsHeaderReplyTo;
    private String jmsHeaderCorrelationID;
    private byte[] jmsHeaderCorrelationIDAsBytes;
    private String jmsHeaderType;

    HornetQJMSProducer(HornetQJMSContext context, MessageProducer producer) {
        this.context = context;
        this.producer = producer;
    }

    public JMSProducer send(Destination destination, Message message) {
        if (message == null) {
            throw new MessageFormatRuntimeException("null message");
        }
        try {
            if (this.jmsHeaderCorrelationID != null) {
                message.setJMSCorrelationID(this.jmsHeaderCorrelationID);
            }
            if (this.jmsHeaderCorrelationIDAsBytes != null && this.jmsHeaderCorrelationIDAsBytes.length > 0) {
                message.setJMSCorrelationIDAsBytes(this.jmsHeaderCorrelationIDAsBytes);
            }
            if (this.jmsHeaderReplyTo != null) {
                message.setJMSReplyTo(this.jmsHeaderReplyTo);
            }
            if (this.jmsHeaderType != null) {
                message.setJMSType(this.jmsHeaderType);
            }
            this.setProperties(message);
            if (this.completionListener != null) {
                CompletionListenerWrapper wrapped = new CompletionListenerWrapper(this.completionListener, this.context);
                this.producer.send(destination, message, (CompletionListener)wrapped);
            } else {
                this.producer.send(destination, message);
            }
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    private void setProperties(Message message) throws JMSException {
        for (SimpleString name : this.properties.getPropertyNames()) {
            message.setObjectProperty(name.toString(), this.properties.getProperty(name));
        }
    }

    public JMSProducer send(Destination destination, String body) {
        TextMessage message = this.context.createTextMessage(body);
        this.send(destination, (Message)message);
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        MapMessage message = this.context.createMapMessage();
        if (body != null) {
            try {
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    String name = entry.getKey();
                    Object v = entry.getValue();
                    if (v instanceof String) {
                        message.setString(name, (String)v);
                        continue;
                    }
                    if (v instanceof Long) {
                        message.setLong(name, ((Long)v).longValue());
                        continue;
                    }
                    if (v instanceof Double) {
                        message.setDouble(name, ((Double)v).doubleValue());
                        continue;
                    }
                    if (v instanceof Integer) {
                        message.setInt(name, ((Integer)v).intValue());
                        continue;
                    }
                    if (v instanceof Character) {
                        message.setChar(name, ((Character)v).charValue());
                        continue;
                    }
                    if (v instanceof Short) {
                        message.setShort(name, ((Short)v).shortValue());
                        continue;
                    }
                    if (v instanceof Boolean) {
                        message.setBoolean(name, ((Boolean)v).booleanValue());
                        continue;
                    }
                    if (v instanceof Float) {
                        message.setFloat(name, ((Float)v).floatValue());
                        continue;
                    }
                    if (v instanceof Byte) {
                        message.setByte(name, ((Byte)v).byteValue());
                        continue;
                    }
                    if (v instanceof byte[]) {
                        byte[] array = (byte[])v;
                        message.setBytes(name, array, 0, array.length);
                        continue;
                    }
                    message.setObject(name, v);
                }
            }
            catch (JMSException e) {
                throw new MessageFormatRuntimeException(e.getMessage());
            }
        }
        this.send(destination, (Message)message);
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        BytesMessage message = this.context.createBytesMessage();
        if (body != null) {
            try {
                message.writeBytes(body);
            }
            catch (JMSException e) {
                throw new MessageFormatRuntimeException(e.getMessage());
            }
        }
        this.send(destination, (Message)message);
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        ObjectMessage message = this.context.createObjectMessage(body);
        this.send(destination, (Message)message);
        return this;
    }

    public JMSProducer setDisableMessageID(boolean value) {
        try {
            this.producer.setDisableMessageID(value);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    public boolean getDisableMessageID() {
        try {
            return this.producer.getDisableMessageID();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) {
        try {
            this.producer.setDisableMessageTimestamp(value);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        try {
            return this.producer.getDisableMessageTimestamp();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        try {
            this.producer.setDeliveryMode(deliveryMode);
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        return this;
    }

    public int getDeliveryMode() {
        try {
            return this.producer.getDeliveryMode();
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    public JMSProducer setPriority(int priority) {
        try {
            this.producer.setPriority(priority);
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        return this;
    }

    public int getPriority() {
        try {
            return this.producer.getPriority();
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        try {
            this.producer.setTimeToLive(timeToLive);
            return this;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    public long getTimeToLive() {
        long timeToLive = 0L;
        try {
            timeToLive = this.producer.getTimeToLive();
            return timeToLive;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        try {
            this.producer.setDeliveryDelay(deliveryDelay);
            return this;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    public long getDeliveryDelay() {
        long deliveryDelay = 0L;
        try {
            deliveryDelay = this.producer.getDeliveryDelay();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deliveryDelay;
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.properties.putBooleanProperty(new SimpleString(name), value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.properties.putByteProperty(new SimpleString(name), value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.properties.putShortProperty(new SimpleString(name), value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.properties.putIntProperty(new SimpleString(name), value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.properties.putLongProperty(new SimpleString(name), value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.properties.putFloatProperty(new SimpleString(name), value);
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.properties.putDoubleProperty(new SimpleString(name), value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.properties.putSimpleStringProperty(new SimpleString(name), new SimpleString(value));
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        try {
            TypedProperties.setObjectProperty((SimpleString)new SimpleString(name), (Object)value, (TypedProperties)this.properties);
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        return this;
    }

    public JMSProducer clearProperties() {
        try {
            this.properties.clear();
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        return this;
    }

    public boolean propertyExists(String name) {
        return this.properties.containsProperty(new SimpleString(name));
    }

    public boolean getBooleanProperty(String name) {
        try {
            return this.properties.getBooleanProperty(new SimpleString(name));
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public byte getByteProperty(String name) {
        try {
            return this.properties.getByteProperty(new SimpleString(name));
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public short getShortProperty(String name) {
        try {
            return this.properties.getShortProperty(new SimpleString(name));
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public int getIntProperty(String name) {
        try {
            return this.properties.getIntProperty(new SimpleString(name));
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public long getLongProperty(String name) {
        try {
            return this.properties.getLongProperty(new SimpleString(name));
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public float getFloatProperty(String name) {
        try {
            return this.properties.getFloatProperty(new SimpleString(name)).floatValue();
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public double getDoubleProperty(String name) {
        try {
            return this.properties.getDoubleProperty(new SimpleString(name));
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public String getStringProperty(String name) {
        try {
            SimpleString prop = this.properties.getSimpleStringProperty(new SimpleString(name));
            if (prop == null) {
                return null;
            }
            return prop.toString();
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public Object getObjectProperty(String name) {
        try {
            return this.properties.getProperty(new SimpleString(name));
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public Set<String> getPropertyNames() {
        try {
            HashSet<String> propNames = new HashSet<String>();
            for (SimpleString str : this.properties.getPropertyNames()) {
                propNames.add(str.toString());
            }
            return propNames;
        }
        catch (RuntimeException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        if (correlationID == null || correlationID.length == 0) {
            throw new JMSRuntimeException("Please specify a non-zero length byte[]");
        }
        this.jmsHeaderCorrelationIDAsBytes = Arrays.copyOf(correlationID, correlationID.length);
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return Arrays.copyOf(this.jmsHeaderCorrelationIDAsBytes, this.jmsHeaderCorrelationIDAsBytes.length);
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.jmsHeaderCorrelationID = correlationID;
        return this;
    }

    public String getJMSCorrelationID() {
        return this.jmsHeaderCorrelationID;
    }

    public JMSProducer setJMSType(String type) {
        this.jmsHeaderType = type;
        return this;
    }

    public String getJMSType() {
        return this.jmsHeaderType;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.jmsHeaderReplyTo = replyTo;
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.jmsHeaderReplyTo;
    }

    static final class CompletionListenerWrapper
    implements CompletionListener {
        private final CompletionListener wrapped;
        private final ThreadAwareContext taContext;

        public CompletionListenerWrapper(CompletionListener wrapped, ThreadAwareContext taContext) {
            this.wrapped = wrapped;
            this.taContext = taContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompletion(Message message) {
            this.taContext.setCurrentThread(Thread.currentThread());
            try {
                this.wrapped.onCompletion(message);
            }
            finally {
                this.taContext.setCurrentThread(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Message message, Exception exception) {
            this.taContext.setCurrentThread(Thread.currentThread());
            try {
                this.wrapped.onException(message, exception);
            }
            finally {
                this.taContext.setCurrentThread(null);
            }
        }
    }
}

