/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class CredentialImpl
implements Credential {
    private static final long serialVersionUID = -5842402120520191086L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final String userName;
    private final String password;
    private final String securityDomain;

    public CredentialImpl(String userName, String password, String securityDomain) throws ValidateException {
        this.userName = userName;
        this.password = password;
        this.securityDomain = securityDomain;
        this.validate();
    }

    public final String getUserName() {
        return this.userName;
    }

    public final String getPassword() {
        return this.password;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.securityDomain == null ? 0 : this.securityDomain.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialImpl)) {
            return false;
        }
        CredentialImpl other = (CredentialImpl)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.securityDomain == null ? other.securityDomain != null : !this.securityDomain.equals(other.securityDomain)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public final String getSecurityDomain() {
        return this.securityDomain;
    }

    public void validate() throws ValidateException {
        if (this.userName != null && this.securityDomain != null) {
            throw new ValidateException(bundle.invalidSecurityConfiguration());
        }
    }
}

