/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.ra16;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.Icon;
import org.jboss.jca.common.api.metadata.ra.LicenseType;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra16.Connector16;
import org.jboss.jca.common.metadata.ra.ra15.Connector15Impl;

public final class Connector16Impl
extends Connector15Impl
implements Connector16 {
    private static final long serialVersionUID = -6095735191032372517L;
    private final XsdString moduleName;
    private ArrayList<XsdString> requiredWorkContexts;
    private final boolean metadataComplete;

    public Connector16Impl(String moduleName, XsdString vendorName, XsdString eisType, XsdString resourceadapterVersion, LicenseType license, ResourceAdapter1516 resourceadapter, List<String> requiredWorkContexts, boolean metadataComplete, List<LocalizedXsdString> description, List<LocalizedXsdString> displayNames, List<Icon> icons, String id) {
        this(new XsdString(moduleName, null), vendorName, eisType, resourceadapterVersion, license, resourceadapter, null, metadataComplete, description, displayNames, icons, id);
        if (requiredWorkContexts != null) {
            this.requiredWorkContexts = new ArrayList(requiredWorkContexts.size());
            for (String wc : requiredWorkContexts) {
                this.requiredWorkContexts.add(new XsdString(wc, null, Connector16.Tag.REQUIRED_WORK_CONTEXT.toString()));
            }
        } else {
            this.requiredWorkContexts = new ArrayList(0);
        }
    }

    public Connector16Impl(XsdString moduleName, XsdString vendorName, XsdString eisType, XsdString resourceadapterVersion, LicenseType license, ResourceAdapter1516 resourceadapter, List<XsdString> requiredWorkContexts, boolean metadataComplete, List<LocalizedXsdString> description, List<LocalizedXsdString> displayNames, List<Icon> icons, String id) {
        super(vendorName, eisType, resourceadapterVersion, license, resourceadapter, description, displayNames, icons, id);
        this.moduleName = moduleName;
        if (!XsdString.isNull((XsdString)this.moduleName)) {
            this.moduleName.setTag(Connector16.Tag.MODULE_NAME.toString());
        }
        if (requiredWorkContexts != null) {
            this.requiredWorkContexts = new ArrayList(requiredWorkContexts.size());
            this.requiredWorkContexts.addAll(requiredWorkContexts);
            for (XsdString wc : this.requiredWorkContexts) {
                wc.setTag(Connector16.Tag.REQUIRED_WORK_CONTEXT.toString());
            }
        } else {
            this.requiredWorkContexts = new ArrayList(0);
        }
        this.metadataComplete = metadataComplete;
    }

    public List<String> getRequiredWorkContexts() {
        if (this.requiredWorkContexts == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(this.requiredWorkContexts.size());
        for (XsdString wc : this.requiredWorkContexts) {
            result.add(wc.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public String getModuleName() {
        if (XsdString.isNull((XsdString)this.moduleName)) {
            return null;
        }
        return this.moduleName.getValue();
    }

    @Override
    public List<LocalizedXsdString> getDescriptions() {
        return this.description == null ? null : Collections.unmodifiableList(this.description);
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    @Override
    public Connector.Version getVersion() {
        return Connector.Version.V_16;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.metadataComplete ? 1231 : 1237);
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (this.requiredWorkContexts == null ? 0 : this.requiredWorkContexts.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Connector16Impl)) {
            return false;
        }
        Connector16Impl other = (Connector16Impl)obj;
        if (this.metadataComplete != other.metadataComplete) {
            return false;
        }
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals((Object)other.moduleName)) {
            return false;
        }
        return !(this.requiredWorkContexts == null ? other.requiredWorkContexts != null : !this.requiredWorkContexts.equals(other.requiredWorkContexts));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<").append("connector");
        sb.append(" " + Connector16.Attribute.VERSION + "=\"1.6\"");
        sb.append(" " + Connector16.Attribute.METADATA_COMPLETE + "=\"" + this.metadataComplete + "\"");
        if (this.id != null) {
            sb.append(" " + Connector16.Attribute.ID + "=\"" + this.id + "\"");
        }
        sb.append(">");
        if (this.moduleName != null) {
            sb.append(this.moduleName);
        }
        sb.append(super.defaultPropertiesToString());
        if (!XsdString.isNull((XsdString)this.resourceadapterVersion)) {
            sb.append(this.resourceadapterVersion);
        }
        sb.append(this.resourceadapter);
        if (this.requiredWorkContexts != null) {
            for (XsdString rwc : this.requiredWorkContexts) {
                sb.append(rwc);
            }
        }
        sb.append("</").append("connector").append(">");
        return sb.toString();
    }

    @Override
    public Connector merge(MergeableMetadata<?> inputMd) throws Exception {
        if (inputMd instanceof Connector16Impl) {
            Connector16Impl input16 = (Connector16Impl)inputMd;
            XsdString newResourceadapterVersion = XsdString.isNull((XsdString)this.resourceadapterVersion) ? input16.resourceadapterVersion : this.resourceadapterVersion;
            XsdString newEisType = XsdString.isNull((XsdString)this.eisType) ? input16.eisType : this.eisType;
            List newRequiredWorkContexts = MergeUtil.mergeList(this.requiredWorkContexts, input16.requiredWorkContexts);
            XsdString newModuleName = this.moduleName == null ? input16.moduleName : this.moduleName;
            List newIcons = MergeUtil.mergeList((List)this.icon, (List)input16.icon);
            boolean newMetadataComplete = this.metadataComplete || input16.metadataComplete;
            LicenseType newLicense = this.license == null ? input16.license : this.license.merge((MergeableMetadata)input16.license);
            List newDescriptions = MergeUtil.mergeList((List)this.description, (List)input16.description);
            List newDisplayNames = MergeUtil.mergeList((List)this.displayName, (List)input16.displayName);
            XsdString newVendorName = XsdString.isNull((XsdString)this.vendorName) ? input16.vendorName : this.vendorName;
            ResourceAdapter1516 newResourceadapter = this.resourceadapter == null ? (ResourceAdapter1516)input16.resourceadapter : (ResourceAdapter1516)((ResourceAdapter1516)this.resourceadapter).merge((MergeableMetadata)((ResourceAdapter1516)input16.resourceadapter));
            return new Connector16Impl(newModuleName, newVendorName, newEisType, newResourceadapterVersion, newLicense, newResourceadapter, newRequiredWorkContexts, newMetadataComplete, (List<LocalizedXsdString>)newDescriptions, (List<LocalizedXsdString>)newDisplayNames, (List<Icon>)newIcons, null);
        }
        return this;
    }

    @Override
    public CopyableMetaData copy() {
        XsdString newResourceadapterVersion = (XsdString)CopyUtil.clone((CopyableMetaData)this.resourceadapterVersion);
        XsdString newEisType = XsdString.isNull((XsdString)this.eisType) ? null : (XsdString)this.eisType.copy();
        List newRequiredWorkContexts = CopyUtil.cloneList(this.requiredWorkContexts);
        XsdString newModuleName = (XsdString)CopyUtil.clone((CopyableMetaData)this.moduleName);
        List newIcons = CopyUtil.cloneList((List)this.icon);
        boolean newMetadataComplete = this.metadataComplete;
        LicenseType newLicense = (LicenseType)CopyUtil.clone((CopyableMetaData)this.license);
        List newDescriptions = CopyUtil.cloneList((List)this.description);
        List newDisplayNames = CopyUtil.cloneList((List)this.displayName);
        XsdString newVendorName = (XsdString)CopyUtil.clone((CopyableMetaData)this.vendorName);
        ResourceAdapter1516 newResourceadapter = (ResourceAdapter1516)CopyUtil.clone((CopyableMetaData)((ResourceAdapter1516)this.resourceadapter));
        return new Connector16Impl(newModuleName, newVendorName, newEisType, newResourceadapterVersion, newLicense, newResourceadapter, newRequiredWorkContexts, newMetadataComplete, (List<LocalizedXsdString>)newDescriptions, (List<LocalizedXsdString>)newDisplayNames, (List<Icon>)newIcons, CopyUtil.cloneString((String)this.id));
    }
}

