/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.expression;

import java.io.Serializable;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.expression.ExpressionImpl;

public class ParameterExpressionImpl<T>
extends ExpressionImpl<T>
implements ParameterExpression<T>,
Serializable {
    private final String name;
    private final Integer position;

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, String name) {
        super(criteriaBuilder, javaType);
        this.name = name;
        this.position = null;
    }

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Integer position) {
        super(criteriaBuilder, javaType);
        this.name = null;
        this.position = position;
    }

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        super(criteriaBuilder, javaType);
        this.name = null;
        this.position = null;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPosition() {
        return this.position;
    }

    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        registry.registerParameter(this);
    }

    @Override
    public String render(RenderingContext renderingContext) {
        String jpaqlParamName = renderingContext.registerExplicitParameter(this);
        return ':' + jpaqlParamName;
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

