/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.graph.internal.advisor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.jpa.graph.internal.EntityGraphImpl;
import org.hibernate.jpa.graph.internal.advisor.AdviceHelper;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphCollectionReference;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphReference;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphSingularAttributeReference;
import org.hibernate.jpa.graph.internal.advisor.NoOpJpaGraphReference;
import org.hibernate.jpa.graph.spi.AttributeNodeImplementor;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.jboss.logging.Logger;

class JpaGraphRootEntityReference
implements JpaGraphReference {
    private static final Logger log = Logger.getLogger(JpaGraphRootEntityReference.class);
    private final Map<String, AttributeNodeImplementor> graphAttributeMap = new HashMap<String, AttributeNodeImplementor>();

    JpaGraphRootEntityReference(EntityGraphImpl entityGraph) {
        List<AttributeNodeImplementor<?>> explicitAttributeNodes = entityGraph.attributeImplementorNodes();
        if (explicitAttributeNodes != null) {
            for (AttributeNodeImplementor<?> node : explicitAttributeNodes) {
                this.graphAttributeMap.put(node.getAttributeName(), node);
            }
        }
    }

    @Override
    public JpaGraphReference attributeProcessed(String attributeName) {
        AttributeNodeImplementor attributeNode = this.graphAttributeMap.remove(attributeName);
        if (attributeNode == null) {
            return NoOpJpaGraphReference.INSTANCE;
        }
        return attributeNode.getAttribute().isCollection() ? new JpaGraphCollectionReference(attributeNode) : new JpaGraphSingularAttributeReference(attributeNode);
    }

    @Override
    public void applyMissingFetches(FetchOwner fetchOwner) {
        for (AttributeNodeImplementor attributeNode : this.graphAttributeMap.values()) {
            System.out.println(String.format("Found unprocessed attribute node [%s], applying to fetch-owner [%s]", attributeNode.getAttributeName(), fetchOwner.getPropertyPath().getFullPath()));
            log.tracef("Found unprocessed attribute node [%s], applying to fetch-owner [%s]", (Object)attributeNode.getAttributeName(), (Object)fetchOwner.getPropertyPath());
            AdviceHelper.buildFetch(fetchOwner, attributeNode);
        }
    }
}

