/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.util;

public enum TxStatus {
    TransactionRollbackOnly(3, 7),
    TransactionRollingBack(2, 8),
    TransactionRolledBack(4, 7),
    TransactionCommitting(6, 8),
    TransactionCommitted(7, 7),
    TransactionHeuristicRollback(11, 3),
    TransactionHeuristicCommit(12, 4),
    TransactionHeuristicHazard(14, 6),
    TransactionHeuristicMixed(13, 5),
    TransactionPreparing(1, 8),
    TransactionPrepared(5, 0),
    TransactionActive(0, 8),
    TransactionCommittedOnePhase(36, 7),
    TransactionReadOnly(37, 2),
    TransactionStatusUnknown(39, 8);

    private final int status;
    private final int twoPhaseOutcome;

    private TxStatus(int status, int twoPhaseOutcome) {
        this.status = status;
        this.twoPhaseOutcome = twoPhaseOutcome;
    }

    public int status() {
        return this.status;
    }

    public int twoPhaseOutcome() {
        return this.twoPhaseOutcome;
    }

    public static boolean isPrepare(String status) {
        return TxStatus.fromStatus(status).equals((Object)TransactionPrepared);
    }

    public static boolean isCommit(String status) {
        return TxStatus.fromStatus(status).equals((Object)TransactionCommitted);
    }

    public static boolean isAbort(String status) {
        return TxStatus.fromStatus(status).equals((Object)TransactionRolledBack);
    }

    public static boolean isReadOnly(String status) {
        return TxStatus.fromStatus(status).equals((Object)TransactionReadOnly);
    }

    public static boolean isCommitOnePhase(String status) {
        return TxStatus.fromStatus(status).equals((Object)TransactionCommittedOnePhase);
    }

    public boolean isPrepare() {
        return this.equals((Object)TransactionPrepared);
    }

    public boolean isCommit() {
        return this.equals((Object)TransactionCommitted);
    }

    public boolean isCommitOnePhase() {
        return this.equals((Object)TransactionCommittedOnePhase);
    }

    public boolean isAbort() {
        return this.equals((Object)TransactionRolledBack);
    }

    public boolean isReadOnly() {
        return this.equals((Object)TransactionReadOnly);
    }

    public boolean isRunning() {
        return this.equals((Object)TransactionActive);
    }

    public boolean isHeuristic() {
        switch (this.status) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean isComplete() {
        switch (this.status) {
            case 4: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isGone() {
        return this.isComplete();
    }

    public boolean isFinished() {
        switch (this.status) {
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        switch (this.status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isFinishing() {
        switch (this.status) {
            case 1: 
            case 2: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean hasHeuristic() {
        switch (this.status) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static TxStatus fromStatus(String status) {
        try {
            return TxStatus.valueOf(TxStatus.class, status);
        }
        catch (Exception e) {
            return TransactionStatusUnknown;
        }
    }

    public static TxStatus fromActionStatus(int actionStatus) {
        switch (actionStatus) {
            case 3: {
                return TransactionRollbackOnly;
            }
            case 2: {
                return TransactionRollingBack;
            }
            case 4: {
                return TransactionRolledBack;
            }
            case 6: {
                return TransactionCommitting;
            }
            case 7: {
                return TransactionCommitted;
            }
            case 11: {
                return TransactionHeuristicRollback;
            }
            case 12: {
                return TransactionHeuristicCommit;
            }
            case 14: {
                return TransactionHeuristicHazard;
            }
            case 13: {
                return TransactionHeuristicMixed;
            }
            case 1: {
                return TransactionPreparing;
            }
            case 5: {
                return TransactionPrepared;
            }
            case 0: {
                return TransactionActive;
            }
        }
        return TransactionStatusUnknown;
    }
}

