/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.proton;

import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientConsumerImpl;
import org.hornetq.core.protocol.proton.ProtonDeliveryHandler;
import org.hornetq.core.protocol.proton.ProtonProtocolManager;
import org.hornetq.core.protocol.proton.ProtonRemotingConnection;
import org.hornetq.core.protocol.proton.ProtonSession;
import org.hornetq.core.protocol.proton.ProtonUtils;
import org.hornetq.core.protocol.proton.exceptions.HornetQAMQPException;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.QueueQueryResult;
import org.hornetq.core.server.ServerMessage;

public class ProtonConsumer
implements ProtonDeliveryHandler {
    private static final Symbol SELECTOR = Symbol.getSymbol((String)"jms-selector");
    private static final Symbol COPY = Symbol.valueOf((String)"copy");
    private final ProtonSession protonSession;
    private final HornetQServer server;
    private final Sender sender;
    private final ProtonRemotingConnection connection;
    private final ProtonProtocolManager protonProtocolManager;
    private long consumerID;
    private boolean closed = false;
    private long forcedDeliveryCount = 0L;
    private boolean forcingDelivery = false;
    private boolean receivedForcedDelivery = true;
    int x = 5;

    public ProtonConsumer(ProtonRemotingConnection connection, Sender sender, ProtonSession protonSession, HornetQServer server, ProtonProtocolManager protonProtocolManager) {
        this.connection = connection;
        this.sender = sender;
        this.protonSession = protonSession;
        this.server = server;
        this.protonProtocolManager = protonProtocolManager;
    }

    public void start() throws HornetQAMQPException {
        this.protonSession.getServerSession().start();
        try {
            this.protonSession.getServerSession().receiveConsumerCredits(this.consumerID, -1);
        }
        catch (Exception e) {
            throw HornetQMessageBundle.BUNDLE.errorStartingConsumer(e.getMessage());
        }
    }

    public void init() throws HornetQAMQPException {
        SimpleString queue;
        DescribedType value;
        Source source = (Source)this.sender.getRemoteSource();
        this.consumerID = this.server.getStorageManager().generateUniqueID();
        SimpleString selector = null;
        Map filter = source.getFilter();
        if (filter != null && (value = (DescribedType)filter.get(SELECTOR)) != null) {
            selector = new SimpleString(value.getDescribed().toString());
        }
        if (source.getDynamic()) {
            queue = new SimpleString(UUID.randomUUID().toString());
            try {
                this.protonSession.getServerSession().createQueue(queue, queue, null, true, false);
            }
            catch (Exception e) {
                throw HornetQMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
            }
            source.setAddress(queue.toString());
        } else {
            QueueQueryResult queryResult;
            String address = source.getAddress();
            if (address == null) {
                throw HornetQMessageBundle.BUNDLE.sourceAddressNotSet();
            }
            queue = new SimpleString(source.getAddress());
            try {
                queryResult = this.protonSession.getServerSession().executeQueueQuery(new SimpleString(address));
            }
            catch (Exception e) {
                throw HornetQMessageBundle.BUNDLE.errorFindingTemporaryQueue(e.getMessage());
            }
            if (!queryResult.isExists()) {
                throw HornetQMessageBundle.BUNDLE.sourceAddressDoesntExist();
            }
        }
        boolean browseOnly = source.getDistributionMode() != null && source.getDistributionMode().equals(COPY);
        try {
            this.protonSession.getServerSession().createConsumer(this.consumerID, queue, selector, browseOnly);
        }
        catch (Exception e) {
            throw HornetQMessageBundle.BUNDLE.errorCreatingHornetQConsumer(e.getMessage());
        }
    }

    @Override
    public synchronized void close() throws HornetQAMQPException {
        this.closed = true;
        this.protonSession.removeConsumer(this.consumerID);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public synchronized int handleDelivery(ServerMessage message, int deliveryCount) {
        if (this.closed) {
            return 0;
        }
        if (message.containsProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE)) {
            if (this.forcingDelivery) {
                this.sender.drained();
            } else {
                this.receivedForcedDelivery = true;
                this.forcingDelivery = false;
            }
            return 0;
        }
        if (this.forcingDelivery) {
            this.forcingDelivery = false;
        }
        boolean preSettle = this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        byte[] tag = preSettle ? new byte[]{} : this.protonSession.getTag();
        EncodedMessage encodedMessage = ProtonUtils.OUTBOUND.transform(message, deliveryCount);
        this.protonProtocolManager.handleDelivery(this.sender, tag, encodedMessage, message, this.connection, preSettle);
        return encodedMessage.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws HornetQAMQPException {
        ServerMessage message = (ServerMessage)delivery.getContext();
        boolean preSettle = this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        DeliveryState remoteState = delivery.getRemoteState();
        if (remoteState != null) {
            if (remoteState instanceof Accepted) {
                try {
                    this.protonSession.getServerSession().individualAcknowledge(this.consumerID, message.getMessageID());
                }
                catch (Exception e) {
                    throw HornetQMessageBundle.BUNDLE.errorAcknowledgingMessage(message.getMessageID(), e.getMessage());
                }
            }
            if (remoteState instanceof Released) {
                try {
                    this.protonSession.getServerSession().individualCancel(this.consumerID, message.getMessageID(), false);
                }
                catch (Exception e) {
                    throw HornetQMessageBundle.BUNDLE.errorCancellingMessage(message.getMessageID(), e.getMessage());
                }
            }
            if (remoteState instanceof Rejected || remoteState instanceof Modified) {
                try {
                    this.protonSession.getServerSession().individualCancel(this.consumerID, message.getMessageID(), true);
                }
                catch (Exception e) {
                    throw HornetQMessageBundle.BUNDLE.errorCancellingMessage(message.getMessageID(), e.getMessage());
                }
            }
            Object object = this.connection.getDeliveryLock();
            synchronized (object) {
                delivery.settle();
            }
            if (!preSettle) {
                this.protonSession.replaceTag(delivery.getTag());
            }
            this.sender.offer(1);
        }
    }

    @Override
    public synchronized void checkState() {
        if (!this.forcingDelivery && this.receivedForcedDelivery) {
            try {
                this.forcingDelivery = true;
                this.receivedForcedDelivery = false;
                this.protonSession.getServerSession().forceConsumerDelivery(this.consumerID, this.forcedDeliveryCount++);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String formatTag(byte[] tag) {
        StringBuffer sb = new StringBuffer();
        for (byte b : tag) {
            sb.append(b).append(":");
        }
        return sb.toString();
    }
}

