/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.proton;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.engine.EndpointError;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.protocol.proton.ProtonConsumer;
import org.hornetq.core.protocol.proton.ProtonProducer;
import org.hornetq.core.protocol.proton.ProtonProtocolManager;
import org.hornetq.core.protocol.proton.ProtonRemotingConnection;
import org.hornetq.core.protocol.proton.TransactionHandler;
import org.hornetq.core.protocol.proton.exceptions.HornetQAMQPException;
import org.hornetq.core.protocol.proton.exceptions.HornetQAMQPInternalErrorException;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.remoting.ReadyListener;

public class ProtonSession
implements SessionCallback {
    private final String name;
    private final ProtonRemotingConnection connection;
    private final HornetQServer server;
    private final TransportImpl protonTransport;
    private final ProtonProtocolManager protonProtocolManager;
    private ServerSession serverSession;
    private OperationContext context;
    private int tagCacheSize = 1000;
    private long currentTag = 0L;
    private final List<byte[]> tagCache = new ArrayList<byte[]>();
    private Map<Object, ProtonProducer> producers = new HashMap<Object, ProtonProducer>();
    private Map<Long, ProtonConsumer> consumers = new HashMap<Long, ProtonConsumer>();
    private boolean closed = false;

    public ProtonSession(String name, ProtonRemotingConnection connection, ProtonProtocolManager protonProtocolManager, OperationContext operationContext, HornetQServer server, TransportImpl protonTransport) {
        this.name = name;
        this.connection = connection;
        this.context = operationContext;
        this.server = server;
        this.protonTransport = protonTransport;
        this.protonProtocolManager = protonProtocolManager;
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public void initialise(boolean transacted) throws HornetQAMQPInternalErrorException {
        if (this.serverSession == null) {
            try {
                this.serverSession = this.server.createSession(this.name, this.connection.getLogin(), this.connection.getPasscode(), 102400, this.connection, !transacted, !transacted, false, false, null, this);
            }
            catch (Exception e) {
                throw HornetQMessageBundle.BUNDLE.errorCreatingHornetQSession(e.getMessage());
            }
        }
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    @Override
    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    @Override
    public int sendMessage(ServerMessage message, long consumerID, int deliveryCount) {
        ProtonConsumer protonConsumer = this.consumers.get(consumerID);
        if (protonConsumer != null) {
            return protonConsumer.handleDelivery(message, deliveryCount);
        }
        return 0;
    }

    @Override
    public int sendLargeMessage(ServerMessage message, long consumerID, long bodySize, int deliveryCount) {
        return 0;
    }

    @Override
    public int sendLargeMessageContinuation(long consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    @Override
    public void closed() {
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
    }

    public OperationContext getContext() {
        return this.context;
    }

    public void addProducer(Receiver receiver) throws HornetQAMQPException {
        try {
            ProtonProducer producer = new ProtonProducer(this.connection, this, this.protonProtocolManager, receiver);
            producer.init();
            this.producers.put(receiver, producer);
            receiver.setContext((Object)producer);
            receiver.open();
        }
        catch (HornetQAMQPException e) {
            this.producers.remove(receiver);
            receiver.setTarget(null);
            ((LinkImpl)receiver).setLocalError(new EndpointError(e.getAmqpError(), e.getMessage()));
            receiver.close();
        }
    }

    public void addTransactionHandler(Coordinator coordinator, Receiver receiver) {
        TransactionHandler transactionHandler = new TransactionHandler(this.connection, coordinator, this.protonProtocolManager, this);
        receiver.setContext((Object)transactionHandler);
        receiver.open();
        receiver.flow(100);
    }

    public void addConsumer(Sender sender) throws HornetQAMQPException {
        ProtonConsumer protonConsumer = new ProtonConsumer(this.connection, sender, this, this.server, this.protonProtocolManager);
        try {
            protonConsumer.init();
            this.consumers.put(protonConsumer.getConsumerID(), protonConsumer);
            sender.setContext((Object)protonConsumer);
            sender.open();
            protonConsumer.start();
        }
        catch (HornetQAMQPException e) {
            this.consumers.remove(protonConsumer.getConsumerID());
            sender.setSource(null);
            ((LinkImpl)sender).setLocalError(new EndpointError(e.getAmqpError(), e.getMessage()));
            sender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTag() {
        List<byte[]> list = this.tagCache;
        synchronized (list) {
            byte[] bytes = this.tagCache.size() > 0 ? this.tagCache.remove(0) : Long.toHexString(this.currentTag++).getBytes();
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTag(byte[] tag) {
        List<byte[]> list = this.tagCache;
        synchronized (list) {
            if (this.tagCache.size() < this.tagCacheSize) {
                this.tagCache.add(tag);
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        for (ProtonProducer protonProducer : this.producers.values()) {
            try {
                protonProducer.close();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorClosingSession(e);
            }
        }
        this.producers.clear();
        for (ProtonConsumer protonConsumer : this.consumers.values()) {
            try {
                protonConsumer.close();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorClosingConsumer(e);
            }
        }
        this.consumers.clear();
        try {
            this.getServerSession().rollback(true);
            this.getServerSession().close(false);
        }
        catch (Exception e) {
            HornetQServerLogger.LOGGER.errorClosingSession(e);
        }
        this.closed = true;
    }

    public void removeConsumer(long consumerID) throws HornetQAMQPException {
        this.consumers.remove(consumerID);
        try {
            this.getServerSession().closeConsumer(consumerID);
        }
        catch (Exception e) {
            throw HornetQMessageBundle.BUNDLE.errorClosingConsumer(consumerID, e.getMessage());
        }
    }

    public void removeProducer(Receiver receiver) {
        this.producers.remove(receiver);
    }
}

