/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.net.InetAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.modcluster.container.Connector;
import org.wildfly.extension.undertow.AbstractListenerService;
import org.wildfly.extension.undertow.AjpListenerService;
import org.wildfly.extension.undertow.HttpListenerService;
import org.xnio.XnioWorker;

public class UndertowConnector
implements Connector {
    private AbstractListenerService<?> listener;

    public UndertowConnector(AbstractListenerService<?> listener) {
        this.listener = listener;
    }

    public boolean isReverse() {
        return true;
    }

    public Connector.Type getType() {
        if (this.listener instanceof AjpListenerService) {
            return Connector.Type.AJP;
        }
        if (this.listener instanceof HttpListenerService) {
            if (this.listener.isSecure()) {
                return Connector.Type.HTTPS;
            }
            return Connector.Type.HTTP;
        }
        return null;
    }

    public InetAddress getAddress() {
        return ((SocketBinding)this.listener.getBinding().getValue()).getAddress();
    }

    public void setAddress(InetAddress address) {
    }

    public int getPort() {
        return ((SocketBinding)this.listener.getBinding().getValue()).getPort();
    }

    public boolean isAvailable() {
        return !((XnioWorker)this.listener.getWorker().getValue()).isShutdown();
    }

    public int getMaxThreads() {
        return ((XnioWorker)this.listener.getWorker().getValue()).getIoThreadCount();
    }

    public int getBusyThreads() {
        return 0;
    }

    public long getBytesSent() {
        return 0L;
    }

    public long getBytesReceived() {
        return 0L;
    }

    public long getRequestCount() {
        return 0L;
    }

    public String toString() {
        return this.listener.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowConnector)) {
            return false;
        }
        UndertowConnector connector = (UndertowConnector)object;
        return this.listener.getName().equals(connector.listener.getName());
    }

    public int hashCode() {
        return this.listener.getName().hashCode();
    }
}

