/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLReader_1_0;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLReader_1_1;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLReader_2_0;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;

public enum Namespace {
    UNKNOWN(0, 0, null),
    JGROUPS_1_0(1, 0, new JGroupsSubsystemXMLReader_1_0()),
    JGROUPS_1_1(1, 1, new JGroupsSubsystemXMLReader_1_1()),
    JGROUPS_2_0(2, 0, new JGroupsSubsystemXMLReader_2_0());

    private static final String BASE_URN = "urn:jboss:domain:jgroups:";
    public static final Namespace CURRENT;
    private final int major;
    private final int minor;
    private final XMLElementReader<List<ModelNode>> reader;
    private static final Map<String, Namespace> namespaces;

    private Namespace(int major, int minor, XMLElementReader<List<ModelNode>> reader) {
        this.major = major;
        this.minor = minor;
        this.reader = reader;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String getUri() {
        return BASE_URN + this.major + "." + this.minor;
    }

    public XMLElementReader<List<ModelNode>> getXMLReader() {
        return this.reader;
    }

    public static Namespace forUri(String uri) {
        Namespace element = namespaces.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = JGROUPS_2_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUri();
            if (name == null) continue;
            map.put(name, namespace);
        }
        namespaces = map;
    }
}

