/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.ContentEncryptedElements;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ContentEncryptedElementsBuilder
implements AssertionBuilder<Element> {
    public Assertion build(Element element, AssertionBuilderFactory factory) {
        ContentEncryptedElements contentEncryptedElements = new ContentEncryptedElements(SP12Constants.INSTANCE);
        String attrXPathVersion = DOMUtils.getAttribute((Element)element, (QName)SP12Constants.ATTR_XPATH_VERSION);
        if (attrXPathVersion != null) {
            contentEncryptedElements.setXPathVersion(attrXPathVersion);
        }
        for (Node nd = element.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (!(nd instanceof Element)) continue;
            this.processElement((Element)nd, contentEncryptedElements);
        }
        return contentEncryptedElements;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.CONTENT_ENCRYPTED_ELEMENTS};
    }

    private void processElement(Element element, ContentEncryptedElements parent) {
        if ("XPath".equals(element.getLocalName())) {
            parent.addXPathExpression(DOMUtils.getRawContent((Node)element));
            this.addNamespaces(element, parent);
        }
    }

    private void addNamespaces(Node element, ContentEncryptedElements parent) {
        if (element.getParentNode() != null) {
            this.addNamespaces(element.getParentNode(), parent);
        }
        if (element instanceof Element) {
            Element el = (Element)element;
            NamedNodeMap map = el.getAttributes();
            for (int x = 0; x < map.getLength(); ++x) {
                Attr attr = (Attr)map.item(x);
                if (!"xmlns".equals(attr.getPrefix())) continue;
                parent.addDeclaredNamespaces(attr.getValue(), attr.getLocalName());
            }
        }
    }
}

