/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public class Servlet3AsyncHttpRequest
extends HttpServletInputMessage {
    protected HttpServletResponse response;
    protected ResteasyAsynchronousContext asynchronousContext;

    public Servlet3AsyncHttpRequest(HttpServletRequest httpServletRequest, HttpServletResponse response, ServletContext servletContext, HttpResponse httpResponse, ResteasyHttpHeaders httpHeaders, ResteasyUriInfo uriInfo, String s, SynchronousDispatcher synchronousDispatcher) {
        super(httpServletRequest, response, servletContext, httpResponse, httpHeaders, uriInfo, s, synchronousDispatcher);
        this.response = response;
        this.asynchronousContext = new Servlet3ExecutionContext((ServletRequest)httpServletRequest);
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return this.asynchronousContext;
    }

    private class Servlet3ExecutionContext
    extends AbstractExecutionContext {
        protected final ServletRequest servletRequest;
        protected boolean done;
        protected boolean cancelled;
        protected boolean timeout;
        protected boolean wasSuspended;
        protected Servle3AsychronousResponse asynchronousResponse;

        public Servlet3ExecutionContext(ServletRequest servletRequest) {
            super(Servlet3AsyncHttpRequest.this.dispatcher, (HttpRequest)Servlet3AsyncHttpRequest.this, Servlet3AsyncHttpRequest.this.httpResponse);
            this.servletRequest = servletRequest;
        }

        public ResteasyAsynchronousResponse getAsyncResponse() {
            return this.asynchronousResponse;
        }

        public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
            return this.suspend(-1L);
        }

        public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
            return this.suspend(millis, TimeUnit.MILLISECONDS);
        }

        public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
            if (this.servletRequest.isAsyncStarted()) {
                throw new IllegalStateException("Already suspended");
            }
            this.asynchronousResponse = new Servle3AsychronousResponse();
            AsyncContext asyncContext = this.servletRequest.startAsync();
            asyncContext.setTimeout(unit.toMillis(time));
            asyncContext.addListener((AsyncListener)this.asynchronousResponse);
            this.wasSuspended = true;
            return this.asynchronousResponse;
        }

        private AsyncContext getAsyncContext() {
            AsyncContext asyncContext = this.servletRequest.getAsyncContext();
            if (asyncContext == null) {
                throw new IllegalStateException("Request not suspended");
            }
            return asyncContext;
        }

        public boolean isSuspended() {
            return this.wasSuspended;
        }

        private class Servle3AsychronousResponse
        extends AbstractAsynchronousResponse
        implements AsyncListener {
            private Object responseLock;

            private Servle3AsychronousResponse() {
                super(Servlet3ExecutionContext.this.dispatcher, Servlet3ExecutionContext.this.request, Servlet3ExecutionContext.this.response);
                this.responseLock = new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Object entity) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (Servlet3ExecutionContext.this.done) {
                        return false;
                    }
                    if (Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    try {
                        bl = this.internalResume(entity);
                        Servlet3ExecutionContext.this.done = true;
                    }
                    catch (Throwable throwable) {
                        Servlet3ExecutionContext.this.done = true;
                        asyncContext.complete();
                        throw throwable;
                    }
                    asyncContext.complete();
                    return bl;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Throwable exc) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (Servlet3ExecutionContext.this.done) {
                        return false;
                    }
                    if (Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    try {
                        bl = this.internalResume(exc);
                        Servlet3ExecutionContext.this.done = true;
                    }
                    catch (Throwable throwable) {
                        Servlet3ExecutionContext.this.done = true;
                        asyncContext.complete();
                        throw throwable;
                    }
                    asyncContext.complete();
                    return bl;
                }
            }

            public void initialRequestThreadFinished() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setTimeout(long time, TimeUnit unit) throws IllegalStateException {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.done || Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                }
                AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                asyncContext.setTimeout(unit.toMillis(time));
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (Servlet3ExecutionContext.this.done || Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    Servlet3ExecutionContext.this.done = true;
                    Servlet3ExecutionContext.this.cancelled = true;
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    try {
                        bl = this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                    }
                    catch (Throwable throwable) {
                        asyncContext.complete();
                        throw throwable;
                    }
                    asyncContext.complete();
                    return bl;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(int retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (Servlet3ExecutionContext.this.done || Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    Servlet3ExecutionContext.this.done = true;
                    Servlet3ExecutionContext.this.cancelled = true;
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    try {
                        bl = this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build());
                    }
                    catch (Throwable throwable) {
                        asyncContext.complete();
                        throw throwable;
                    }
                    asyncContext.complete();
                    return bl;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(Date retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    boolean bl;
                    if (Servlet3ExecutionContext.this.done || Servlet3ExecutionContext.this.cancelled) {
                        return false;
                    }
                    Servlet3ExecutionContext.this.done = true;
                    Servlet3ExecutionContext.this.cancelled = true;
                    AsyncContext asyncContext = Servlet3ExecutionContext.this.getAsyncContext();
                    try {
                        bl = this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build());
                    }
                    catch (Throwable throwable) {
                        asyncContext.complete();
                        throw throwable;
                    }
                    asyncContext.complete();
                    return bl;
                }
            }

            public boolean isCancelled() {
                return Servlet3ExecutionContext.this.cancelled;
            }

            public boolean isDone() {
                return Servlet3ExecutionContext.this.done;
            }

            public boolean isSuspended() {
                return !Servlet3ExecutionContext.this.done && !Servlet3ExecutionContext.this.cancelled;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                Object object = this.responseLock;
                synchronized (object) {
                    Servlet3ExecutionContext.this.done = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                Object object = this.responseLock;
                synchronized (object) {
                    if (Servlet3ExecutionContext.this.done || Servlet3ExecutionContext.this.cancelled) {
                        return;
                    }
                    this.response.reset();
                    if (this.timeoutHandler != null) {
                        this.timeoutHandler.handleTimeout((AsyncResponse)this);
                    }
                    if (Servlet3ExecutionContext.this.done) {
                        return;
                    }
                    this.cancel();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(AsyncEvent asyncEvent) throws IOException {
                Object object = this.responseLock;
                synchronized (object) {
                    Servlet3ExecutionContext.this.cancelled = true;
                    Servlet3ExecutionContext.this.done = true;
                }
            }

            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }
        }
    }
}

