/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.ChannelDependentServiceProvider;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.Services;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryService;

public class CommandDispatcherFactoryProvider
implements ChannelDependentServiceProvider {
    private static final Logger logger = Logger.getLogger(CommandDispatcherFactoryProvider.class);

    private static ServiceName getServiceName(String cluster) {
        return CommandDispatcherFactory.SERVICE_NAME.append(new String[]{cluster});
    }

    public Collection<ServiceName> getServiceNames(String cluster) {
        return Arrays.asList(CommandDispatcherFactoryProvider.getServiceName(cluster), CommandDispatcherFactoryProvider.createBinding(cluster).getBinderServiceName());
    }

    public Collection<ServiceController<?>> install(ServiceTarget target, String cluster, ModuleIdentifier moduleId) {
        ServiceName name = CommandDispatcherFactoryProvider.getServiceName(cluster);
        ContextNames.BindInfo bindInfo = CommandDispatcherFactoryProvider.createBinding(cluster);
        logger.debugf("Installing %s service, bound to ", (Object)name.getCanonicalName(), (Object)bindInfo.getAbsoluteJndiName());
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceController binderController = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{bindInfo.getBindName()})}).addDependency(name, CommandDispatcherFactory.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
        InjectedValue channel = new InjectedValue();
        InjectedValue loader = new InjectedValue();
        CommandDispatcherFactoryService service = new CommandDispatcherFactoryService((Value<Channel>)channel, (Value<ModuleLoader>)loader, moduleId);
        ServiceController controller = target.addService(name, (Service)service).addDependency(CacheService.getServiceName((String)cluster, null)).addDependency(ChannelService.getServiceName((String)cluster), Channel.class, (Injector)channel).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, (Injector)loader).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return Arrays.asList(controller, binderController);
    }

    private static ContextNames.BindInfo createBinding(String cluster) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", "dispatcher", cluster}).getAbsoluteName());
    }
}

