/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jpa.config.ExtendedPersistenceInheritance;
import org.jboss.as.jpa.management.DynamicManagementStatisticsResource;
import org.jboss.as.jpa.management.EntityManagerFactoryLookup;
import org.jboss.as.jpa.management.ManagementResourceDefinition;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.CacheDeploymentHelper;
import org.jboss.as.jpa.service.JPAUserTransactionListenerService;
import org.jboss.as.jpa.transaction.TransactionUtil;
import org.jboss.as.jpa.util.JPAServiceNames;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.TransactionSynchronizationRegistryService;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jipijapa.management.spi.Statistics;
import org.jipijapa.plugin.spi.ManagementAdaptor;

public class JPAService
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = JPAServiceNames.getJPAServiceName();
    private static volatile String defaultDataSourceName = null;
    private static volatile ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance = null;
    private static final Set<String> existingResourceDescriptionResolver = new HashSet<String>();
    private final CacheDeploymentHelper cacheDeploymentHelper = new CacheDeploymentHelper();

    public static String getDefaultDataSourceName() {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.getDefaultDataSourceName() == %s", defaultDataSourceName);
        return defaultDataSourceName;
    }

    public static void setDefaultDataSourceName(String dataSourceName) {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.setDefaultDataSourceName(%s), previous value = %s", dataSourceName, defaultDataSourceName);
        defaultDataSourceName = dataSourceName;
    }

    public static ExtendedPersistenceInheritance getDefaultExtendedPersistenceInheritance() {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.getDefaultExtendedPersistenceInheritance() == %s", defaultExtendedPersistenceInheritance.toString());
        return defaultExtendedPersistenceInheritance;
    }

    public static void setDefaultExtendedPersistenceInheritance(ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance) {
        JpaLogger.ROOT_LOGGER.tracef("JPAService.setDefaultExtendedPersistenceInheritance(%s)", defaultExtendedPersistenceInheritance.toString());
        JPAService.defaultExtendedPersistenceInheritance = defaultExtendedPersistenceInheritance;
    }

    public static ServiceController<?> addService(ServiceTarget target, String defaultDataSourceName, ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance, ServiceListener<Object> ... listeners) {
        JPAService jpaService = new JPAService();
        JPAService.setDefaultDataSourceName(defaultDataSourceName);
        JPAService.setDefaultExtendedPersistenceInheritance(defaultExtendedPersistenceInheritance);
        Injector<TransactionManager> transactionManagerInjector = new Injector<TransactionManager>(){

            public void inject(TransactionManager value) throws InjectionException {
                TransactionUtil.setTransactionManager(value);
            }

            public void uninject() {
            }
        };
        Injector<TransactionSynchronizationRegistry> transactionRegistryInjector = new Injector<TransactionSynchronizationRegistry>(){

            public void inject(TransactionSynchronizationRegistry value) throws InjectionException {
                TransactionUtil.setTransactionSynchronizationRegistry(value);
            }

            public void uninject() {
            }
        };
        return target.addService(SERVICE_NAME, (Service)jpaService).addListener(listeners).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(TransactionManagerService.SERVICE_NAME, (Injector)new CastingInjector((Injector)transactionManagerInjector, TransactionManager.class)).addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, (Injector)new CastingInjector((Injector)transactionRegistryInjector, TransactionSynchronizationRegistry.class)).addDependency(JPAUserTransactionListenerService.SERVICE_NAME).install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource createManagementStatisticsResource(ManagementAdaptor managementAdaptor, String scopedPersistenceUnitName, DeploymentUnit deploymentUnit) {
        Set<String> set = existingResourceDescriptionResolver;
        synchronized (set) {
            EntityManagerFactoryLookup entityManagerFactoryLookup = new EntityManagerFactoryLookup();
            Statistics statistics = managementAdaptor.getStatistics();
            if (!existingResourceDescriptionResolver.contains(managementAdaptor.getVersion())) {
                StandardResourceDescriptionResolver resourceDescriptionResolver = new StandardResourceDescriptionResolver(statistics.getResourceBundleKeyPrefix(), statistics.getResourceBundleName(), statistics.getClass().getClassLoader());
                ManagementResourceRegistration managementResourceRegistration = ((ManagementResourceRegistration)deploymentUnit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT)).getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"jpa")}));
                managementResourceRegistration.registerSubModel((ResourceDefinition)new ManagementResourceDefinition(PathElement.pathElement((String)managementAdaptor.getIdentificationLabel()), (ResourceDescriptionResolver)resourceDescriptionResolver, statistics, entityManagerFactoryLookup));
                existingResourceDescriptionResolver.add(managementAdaptor.getVersion());
            }
            DynamicManagementStatisticsResource result = new DynamicManagementStatisticsResource(statistics, scopedPersistenceUnitName, managementAdaptor.getIdentificationLabel(), entityManagerFactoryLookup);
            return result;
        }
    }

    public void start(StartContext startContext) throws StartException {
        this.cacheDeploymentHelper.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext stopContext) {
        this.cacheDeploymentHelper.unregister();
        Set<String> set = existingResourceDescriptionResolver;
        synchronized (set) {
            existingResourceDescriptionResolver.clear();
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

