/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.ConfigurableAuthorizer;
import org.jboss.as.controller.access.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.rbac.ConfigurableRoleMapper;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AccessAuthorizationProviderWriteAttributeHander;
import org.jboss.as.domain.management.access.AccessAuthorizationUseRealmRolesWriteAttributeHandler;
import org.jboss.as.domain.management.access.AccessConstraintResources;
import org.jboss.as.domain.management.access.ApplicationClassificationParentResourceDefinition;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityClassificationParentResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AccessAuthorizationResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"access", (String)"authorization");
    public static final Resource RESOURCE = AccessAuthorizationResourceDefinition.createResource();
    public static final ListAttributeDefinition HOST_SCOPED_ROLES = SimpleListAttributeDefinition.Builder.of((String)"host-scoped-roles", (AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("role", ModelType.STRING).setAttributeMarshaller(new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEmptyElement(Element.ROLE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), resourceModel.asString());
        }
    })).build()).setMinSize(1).setAllowNull(true).setWrapXmlList(false).build();
    public static final SimpleAttributeDefinition PROVIDER = new SimpleAttributeDefinitionBuilder("provider", ModelType.STRING, true).setDefaultValue(new ModelNode(Provider.SIMPLE.toString())).setValidator((ParameterValidator)new EnumValidator(Provider.class, true, false)).build();
    public static final SimpleAttributeDefinition USE_REALM_ROLES = new SimpleAttributeDefinitionBuilder("use-realm-roles", ModelType.BOOLEAN, false).setDefaultValue(new ModelNode(false)).setAllowExpression(true).build();
    private final DelegatingConfigurableAuthorizer configurableAuthorizer;
    private final ConfigurableRoleMapper roleMapper = new ConfigurableRoleMapper();
    private final boolean isDomain;
    private final boolean isHostController;

    public static AccessAuthorizationResourceDefinition forDomain(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        return new AccessAuthorizationResourceDefinition(configurableAuthorizer, true, false);
    }

    public static AccessAuthorizationResourceDefinition forHost(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        return new AccessAuthorizationResourceDefinition(configurableAuthorizer, true, true);
    }

    public static AccessAuthorizationResourceDefinition forDomainServer(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        return new AccessAuthorizationResourceDefinition(configurableAuthorizer, true, false);
    }

    public static AccessAuthorizationResourceDefinition forStandaloneServer(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        return new AccessAuthorizationResourceDefinition(configurableAuthorizer, false, false);
    }

    private AccessAuthorizationResourceDefinition(DelegatingConfigurableAuthorizer configurableAuthorizer, boolean domain, boolean hostController) {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control"));
        this.configurableAuthorizer = configurableAuthorizer;
        this.isDomain = domain;
        this.isHostController = hostController;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        if (this.isHostController) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)HOST_SCOPED_ROLES, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{HOST_SCOPED_ROLES}){

                protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandback) throws OperationFailedException {
                    return !context.isBooting();
                }
            });
        } else {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)USE_REALM_ROLES, null, (OperationStepHandler)new AccessAuthorizationUseRealmRolesWriteAttributeHandler(this.roleMapper));
        }
        if (!this.isDomain) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PROVIDER, null, (OperationStepHandler)new AccessAuthorizationProviderWriteAttributeHander(this.configurableAuthorizer, (RoleMapper)this.roleMapper));
        } else {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PROVIDER, null, (OperationStepHandler)new ModelOnlyWriteAttributeHandler(new AttributeDefinition[]{PROVIDER}));
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (!this.isHostController) {
            resourceRegistration.registerSubModel((ResourceDefinition)RoleMappingResourceDefinition.create(this.roleMapper));
        }
        if (this.isDomain) {
            resourceRegistration.registerSubModel((ResourceDefinition)new ServerGroupScopedRoleResourceDefinition((ConfigurableAuthorizer)this.configurableAuthorizer));
            if (!this.isHostController) {
                resourceRegistration.registerSubModel((ResourceDefinition)new HostScopedRolesResourceDefinition((ConfigurableAuthorizer)this.configurableAuthorizer));
            }
        }
        if (!this.isHostController) {
            resourceRegistration.registerSubModel((ResourceDefinition)ApplicationClassificationParentResourceDefinition.INSTANCE);
            resourceRegistration.registerSubModel((ResourceDefinition)SensitivityClassificationParentResourceDefinition.INSTANCE);
            resourceRegistration.registerSubModel((ResourceDefinition)SensitivityResourceDefinition.createVaultExpressionConfiguration());
        }
    }

    private static Resource createResource() {
        Resource accessControlRoot = Resource.Factory.create();
        accessControlRoot.registerChild(AccessConstraintResources.APPLICATION_PATH_ELEMENT, AccessConstraintResources.APPLICATION_RESOURCE);
        accessControlRoot.registerChild(AccessConstraintResources.SENSITIVITY_PATH_ELEMENT, AccessConstraintResources.SENSITIVITY_RESOURCE);
        accessControlRoot.registerChild(AccessConstraintResources.VAULT_PATH_ELEMENT, AccessConstraintResources.VAULT_RESOURCE);
        return accessControlRoot;
    }

    public static enum Provider {
        SIMPLE("simple"),
        RBAC("rbac");

        private final String toString;

        private Provider(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

