/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.rbac.ConfigurableRoleMapper;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AccessAuthorizationUseRealmRolesWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final ConfigurableRoleMapper rbacRoleMapper;

    AccessAuthorizationUseRealmRolesWriteAttributeHandler(ConfigurableRoleMapper rbacRoleMapper) {
        super(new AttributeDefinition[]{AccessAuthorizationResourceDefinition.USE_REALM_ROLES});
        this.rbacRoleMapper = rbacRoleMapper;
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        if (newValue.getType() == ModelType.EXPRESSION || !newValue.asBoolean(false)) {
            RbacSanityCheckOperation.registerOperation(context);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        this.setUseRealmRoles(resolvedValue);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        this.setUseRealmRoles(valueToRestore);
    }

    private void setUseRealmRoles(ModelNode value) {
        this.rbacRoleMapper.setUseRealmRoles(value.asBoolean());
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }
}

