/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class RbacSanityCheckOperation
implements OperationStepHandler {
    private static final OperationContext.AttachmentKey<RbacSanityCheckOperation> KEY = OperationContext.AttachmentKey.create(RbacSanityCheckOperation.class);
    private static final RbacSanityCheckOperation INSTANCE = new RbacSanityCheckOperation();

    private RbacSanityCheckOperation() {
    }

    public void execute(final OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws OperationFailedException {
                    ModelChecker checker = new ModelChecker(context, context.readResource(PathAddress.EMPTY_ADDRESS));
                    if (checker.isRbacEnabled() && !checker.canRealmRolesBeUsed() && !checker.doRoleMappingsExist()) {
                        throw DomainManagementMessages.MESSAGES.inconsistentRbacConfiguration();
                    }
                    context.stepCompleted();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof OperationFailedException) {
                throw (OperationFailedException)cause;
            }
            throw new OperationFailedException((Throwable)cause);
        }
    }

    public static void registerOperation(OperationContext context) {
        RbacSanityCheckOperation registered = (RbacSanityCheckOperation)context.getAttachment(KEY);
        if (registered == null) {
            if (!context.isNormalServer()) {
                return;
            }
            context.addStep(RbacSanityCheckOperation.createOperation(), (OperationStepHandler)INSTANCE, OperationContext.Stage.MODEL);
            context.attach(KEY, (Object)INSTANCE);
        }
    }

    private static ModelNode createOperation() {
        ModelNode operation = Util.createEmptyOperation((String)"rbac-sanity-check", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT}));
        return operation;
    }

    private static class ModelChecker {
        private final OperationContext context;
        private final Resource managementResource;
        private ModelNode accessAuthorization;
        private ModelNode managementInterface;
        private ModelNode securityRealm;

        private ModelChecker(OperationContext context, Resource managementResource) {
            this.context = context;
            this.managementResource = managementResource;
        }

        boolean isRbacEnabled() throws OperationFailedException {
            ModelNode accessAuthorization = this.getAccessAuthorization();
            String value = AccessAuthorizationResourceDefinition.PROVIDER.resolveModelAttribute(this.context, accessAuthorization).asString().toUpperCase(Locale.ENGLISH);
            return AccessAuthorizationResourceDefinition.Provider.valueOf(value) == AccessAuthorizationResourceDefinition.Provider.RBAC;
        }

        boolean canRealmRolesBeUsed() throws OperationFailedException {
            ModelNode accessAuthorization = this.getAccessAuthorization();
            if (AccessAuthorizationResourceDefinition.USE_REALM_ROLES.resolveModelAttribute(this.context, accessAuthorization).asBoolean()) {
                return this.canRealmsProvideRoles();
            }
            return false;
        }

        boolean doRoleMappingsExist() throws OperationFailedException {
            Resource authorizationResource = this.managementResource.getChild(PathElement.pathElement((String)"access", (String)"authorization"));
            Set roleNames = authorizationResource.getChildrenNames("role-mapping");
            for (String current : roleNames) {
                Resource roleResource = authorizationResource.getChild(PathElement.pathElement((String)"role-mapping", (String)current));
                if (roleResource.getChildren("include").size() <= 0) continue;
                return true;
            }
            return false;
        }

        private boolean canRealmsProvideRoles() throws OperationFailedException {
            String[] possibleRealms;
            for (String current : possibleRealms = this.getRealmsInUse()) {
                if (!this.realmProvidesRoles(current)) continue;
                return true;
            }
            return false;
        }

        private boolean realmProvidesRoles(String realmName) throws OperationFailedException {
            ModelNode realm = this.getSecurityRealm(realmName);
            if (realm.isDefined() && SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.resolveModelAttribute(this.context, realm).asBoolean()) {
                Resource realmResource = this.managementResource.getChild(PathElement.pathElement((String)"security-realm", (String)realmName));
                return realmResource.hasChild(PathElement.pathElement((String)"authorization"));
            }
            return false;
        }

        private ModelNode getSecurityRealm(String realmName) {
            ModelNode securityRealm = this.getSecurityRealm();
            if (securityRealm.isDefined()) {
                for (Property current : securityRealm.asPropertyList()) {
                    if (!current.getName().equals(realmName)) continue;
                    return current.getValue();
                }
            }
            return new ModelNode();
        }

        private String[] getRealmsInUse() throws OperationFailedException {
            HashSet<String> realms = new HashSet<String>();
            ModelNode managementInterface = this.getManagementInterface();
            if (managementInterface.isDefined()) {
                List interfaces = managementInterface.asPropertyList();
                for (Property current : interfaces) {
                    if (current.getName().equals("native-remoting-interface")) {
                        return this.getAllRealmNames();
                    }
                    ModelNode value = current.getValue();
                    if (!value.hasDefined("security-realm")) continue;
                    realms.add(value.require("security-realm").asString());
                }
            }
            return realms.toArray(new String[realms.size()]);
        }

        private String[] getAllRealmNames() throws OperationFailedException {
            ArrayList<String> realms = new ArrayList<String>();
            ModelNode securityRealm = this.getSecurityRealm();
            if (securityRealm.isDefined()) {
                for (Property current : securityRealm.asPropertyList()) {
                    realms.add(current.getName());
                }
            }
            return realms.toArray(new String[realms.size()]);
        }

        private ModelNode getAccessAuthorization() {
            Resource authorizationResource;
            PathElement pathElement;
            if (this.accessAuthorization == null && this.managementResource.hasChild(pathElement = PathElement.pathElement((String)"access", (String)"authorization")) && (authorizationResource = this.managementResource.getChild(pathElement)).isModelDefined()) {
                this.accessAuthorization = authorizationResource.getModel();
            }
            return this.accessAuthorization;
        }

        private ModelNode getManagementInterface() {
            if (this.managementInterface == null) {
                ModelNode managementInterface = new ModelNode();
                Set children = this.managementResource.getChildren("management-interface");
                for (Resource.ResourceEntry current : children) {
                    managementInterface.add(new Property(current.getName(), current.getModel()));
                }
                this.managementInterface = managementInterface;
            }
            return this.managementInterface;
        }

        private ModelNode getSecurityRealm() {
            if (this.securityRealm == null) {
                ModelNode securityRealm = new ModelNode();
                Set children = this.managementResource.getChildren("security-realm");
                for (Resource.ResourceEntry current : children) {
                    securityRealm.add(new Property(current.getName(), current.getModel()));
                }
                this.securityRealm = securityRealm;
            }
            return this.securityRealm;
        }
    }
}

