/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.rbac.ConfigurableRoleMapper;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.dmr.ModelNode;

public class RoleMappingRemove
implements OperationStepHandler {
    private final ConfigurableRoleMapper roleMapper;

    private RoleMappingRemove(ConfigurableRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public static OperationStepHandler create(ConfigurableRoleMapper roleMapper) {
        return new RoleMappingRemove(roleMapper);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String roleName = address.getLastElement().getValue().toUpperCase();
        RbacSanityCheckOperation.registerOperation(context);
        this.registerRuntimeRemove(context, roleName);
        context.stepCompleted();
    }

    private void registerRuntimeRemove(OperationContext context, final String roleName) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Object undoKey = RoleMappingRemove.this.roleMapper.removeRole(roleName);
                if (undoKey == null) {
                    context.restartRequired();
                    throw DomainManagementMessages.MESSAGES.inconsistentRbacRuntimeState();
                }
                RoleMappingRemove.this.registerRollbackHandler(context, undoKey);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private void registerRollbackHandler(OperationContext context, final Object undoKey) {
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!RoleMappingRemove.this.roleMapper.undoRemove(undoKey)) {
                    context.restartRequired();
                }
            }
        });
    }
}

